/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.project;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.GoodDataRestException;
import com.gooddata.sdk.common.collections.Page;
import com.gooddata.sdk.common.collections.PageBrowser;
import com.gooddata.sdk.common.collections.PageRequest;
import com.gooddata.sdk.common.util.MutableUri;
import com.gooddata.sdk.common.util.SpringMutableUri;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.gdc.AsyncTask;
import com.gooddata.sdk.model.gdc.UriResponse;
import com.gooddata.sdk.model.project.CreatedInvitations;
import com.gooddata.sdk.model.project.Invitation;
import com.gooddata.sdk.model.project.Invitations;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.model.project.ProjectTemplate;
import com.gooddata.sdk.model.project.ProjectTemplates;
import com.gooddata.sdk.model.project.ProjectUsersUpdateResult;
import com.gooddata.sdk.model.project.ProjectValidationResults;
import com.gooddata.sdk.model.project.ProjectValidationType;
import com.gooddata.sdk.model.project.ProjectValidations;
import com.gooddata.sdk.model.project.Projects;
import com.gooddata.sdk.model.project.Role;
import com.gooddata.sdk.model.project.Roles;
import com.gooddata.sdk.model.project.User;
import com.gooddata.sdk.model.project.Users;
import com.gooddata.sdk.service.AbstractPollHandler;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.SimplePollHandler;
import com.gooddata.sdk.service.account.AccountService;
import com.gooddata.sdk.service.project.ProjectNotFoundException;
import com.gooddata.sdk.service.project.ProjectUsersUpdateException;
import com.gooddata.sdk.service.project.RoleNotFoundException;
import com.gooddata.sdk.service.project.UserInProjectNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class ProjectService
extends AbstractService {
    public static final UriTemplate PROJECT_TEMPLATE = new UriTemplate("/gdc/projects/{id}");
    public static final UriTemplate PROJECT_USERS_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/users");
    public static final UriTemplate PROJECT_USER_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/users/{userId}");
    public static final UriTemplate LIST_PROJECTS_TEMPLATE = new UriTemplate("/gdc/account/profile/{id}/projects");
    private final AccountService accountService;

    public ProjectService(RestTemplate restTemplate, AccountService accountService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.accountService = (AccountService)Validate.notNull((Object)accountService, (String)"accountService");
    }

    @Deprecated
    public Collection<Project> getProjects() {
        return this.listProjects().allItemsStream().collect(Collectors.toList());
    }

    public PageBrowser<Project> listProjects() {
        String userId = this.accountService.getCurrent().getId();
        return new PageBrowser(page -> this.listProjects(ProjectService.getProjectsUri(userId, page)));
    }

    public PageBrowser<Project> listProjects(PageRequest startPage) {
        Validate.notNull((Object)startPage, (String)"startPage");
        String userId = this.accountService.getCurrent().getId();
        return new PageBrowser(startPage, page -> this.listProjects(ProjectService.getProjectsUri(userId, page)));
    }

    private Page<Project> listProjects(URI uri) {
        try {
            Projects projects = (Projects)this.restTemplate.getForObject(uri, Projects.class);
            if (projects == null) {
                return new Page();
            }
            return projects;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list projects", e);
        }
    }

    private static URI getProjectsUri(String userId) {
        Validate.notEmpty((CharSequence)userId, (String)"userId");
        return LIST_PROJECTS_TEMPLATE.expand(new Object[]{userId});
    }

    private static URI getProjectsUri(String userId, PageRequest page) {
        return page.getPageUri((MutableUri)new SpringMutableUri(ProjectService.getProjectsUri(userId)));
    }

    public FutureResult<Project> createProject(Project project) {
        UriResponse uri;
        Validate.notNull((Object)project, (String)"project");
        try {
            uri = (UriResponse)this.restTemplate.postForObject("/gdc/projects", (Object)project, UriResponse.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create project", e);
        }
        if (uri == null) {
            throw new GoodDataException("Empty response when project POSTed to API");
        }
        return new PollResult<Project>(this, new SimplePollHandler<Project>(uri.getUri(), Project.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                Project project = (Project)ProjectService.this.extractData(response, Project.class);
                return !project.isPreparing();
            }

            @Override
            protected void onFinish() {
                if (!((Project)this.getResult()).isEnabled()) {
                    throw new GoodDataException("Created project " + uri + " is not enabled");
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Creating project " + uri + " failed", (Throwable)e);
            }
        });
    }

    public Project getProjectByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            return (Project)this.restTemplate.getForObject(uri, Project.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ProjectNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get project " + uri, (Throwable)e);
        }
    }

    public Project getProjectById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"id");
        return this.getProjectByUri(PROJECT_TEMPLATE.expand(new Object[]{id}).toString());
    }

    public void removeProject(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getUri(), (String)"project.uri");
        try {
            this.restTemplate.delete(project.getUri(), new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to delete project " + project.getUri(), e);
        }
    }

    public Collection<ProjectTemplate> getProjectTemplates(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            ProjectTemplates templates = (ProjectTemplates)this.restTemplate.getForObject("/gdc/md/{projectId}/templates", ProjectTemplates.class, new Object[]{project.getId()});
            return templates != null && templates.getTemplatesInfo() != null ? templates.getTemplatesInfo() : Collections.emptyList();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get project templates", e);
        }
    }

    public Set<ProjectValidationType> getAvailableProjectValidationTypes(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            ProjectValidations projectValidations = (ProjectValidations)this.restTemplate.getForObject("/gdc/md/{projectId}/validate", ProjectValidations.class, new Object[]{project.getId()});
            return projectValidations != null ? projectValidations.getValidations() : Collections.emptySet();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get project available validation types", e);
        }
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project) {
        return this.validateProject(project, this.getAvailableProjectValidationTypes(project));
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project, ProjectValidationType ... validations) {
        return this.validateProject(project, new HashSet<ProjectValidationType>(Arrays.asList(validations)));
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project, Set<ProjectValidationType> validations) {
        AsyncTask task;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            task = (AsyncTask)this.restTemplate.postForObject("/gdc/md/{projectId}/validate", (Object)new ProjectValidations(validations), AsyncTask.class, new Object[]{project.getId()});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to to start project validation", e);
        }
        return new PollResult<ProjectValidationResults>(this, new AbstractPollHandler<Void, ProjectValidationResults>(((AsyncTask)Validate.notNullState((Object)task, (String)"project validation task")).getUri(), Void.class, ProjectValidationResults.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                boolean finished;
                URI location = response.getHeaders().getLocation();
                if (location != null) {
                    this.setPollingUri(location.toString());
                }
                if (finished = super.isFinished(response)) {
                    try {
                        ProjectValidationResults result = (ProjectValidationResults)ProjectService.this.restTemplate.getForObject(this.getPollingUri(), this.getResultClass(), new Object[0]);
                        this.setResult(result);
                    }
                    catch (GoodDataException | RestClientException e) {
                        throw new GoodDataException("Unable to obtain validation results from " + this.getPollingUri());
                    }
                }
                return finished;
            }

            @Override
            public void handlePollResult(Void pollResult) {
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Project validation failed: " + this.getPollingUri(), (Throwable)e);
            }
        });
    }

    public PageBrowser<User> listUsers(Project project) {
        Validate.notNull((Object)project, (String)"project");
        return new PageBrowser(page -> this.listUsers(ProjectService.getUsersUri(project, page)));
    }

    public PageBrowser<User> listUsers(Project project, PageRequest startPage) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)startPage, (String)"startPage");
        return new PageBrowser(startPage, page -> this.listUsers(ProjectService.getUsersUri(project, page)));
    }

    private Page<User> listUsers(URI uri) {
        try {
            Users users = (Users)this.restTemplate.getForObject(uri, Users.class);
            if (users == null) {
                return new Page();
            }
            return users;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list users", e);
        }
    }

    private static URI getUsersUri(Project project) {
        Validate.notNull((Object)project.getId(), (String)"project.id");
        return PROJECT_USERS_TEMPLATE.expand(new Object[]{project.getId()});
    }

    private static URI getUsersUri(Project project, PageRequest page) {
        return page.getPageUri((MutableUri)new SpringMutableUri(ProjectService.getUsersUri(project)));
    }

    private static URI getUserUri(Project project, Account account) {
        Validate.notNull((Object)account.getId(), (String)"account.id");
        return PROJECT_USER_TEMPLATE.expand(new Object[]{project.getId(), account.getId()});
    }

    public Set<Role> getRoles(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Roles roles = (Roles)this.restTemplate.getForObject("/gdc/projects/{projectId}/roles", Roles.class, new Object[]{project.getId()});
        if (roles == null) {
            return Collections.emptySet();
        }
        HashSet<Role> result = new HashSet<Role>();
        for (String roleUri : roles.getRoles()) {
            Role role = (Role)this.restTemplate.getForObject(roleUri, Role.class, new Object[0]);
            ((Role)Validate.notNullState((Object)role, (String)"role")).setUri(roleUri);
            result.add(role);
        }
        return result;
    }

    public Role getRoleByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            Role role = (Role)this.restTemplate.getForObject(uri, Role.class, new Object[0]);
            ((Role)Validate.notNullState((Object)role, (String)"role")).setUri(uri);
            return role;
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new RoleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get role " + uri, (Throwable)e);
        }
    }

    public CreatedInvitations sendInvitations(Project project, Invitation ... invitations) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.noNullElements((Object[])invitations, (String)"invitations");
        try {
            return (CreatedInvitations)this.restTemplate.postForObject("/gdc/projects/{id}/invitations", (Object)new Invitations(invitations), CreatedInvitations.class, new Object[]{project.getId()});
        }
        catch (RestClientException e) {
            String emails = Arrays.stream(invitations).map(Invitation::getEmail).collect(Collectors.joining(","));
            throw new GoodDataException("Unable to invite " + emails + " to project " + project.getId(), (Throwable)e);
        }
    }

    public User getUser(Project project, Account account) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)account.getId(), (String)"account.id");
        Validate.notNull((Object)project, (String)"project");
        try {
            return (User)this.restTemplate.getForObject(ProjectService.getUserUri(project, account), User.class);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new UserInProjectNotFoundException("User " + account.getId() + " is not in project", e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get user " + account.getId() + " in project", (Throwable)e);
        }
    }

    public User addUserToProject(Project project, Account account, Role ... userRoles) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)account.getUri(), (String)"account.uri");
        Validate.notNull((Object)userRoles, (String)"userRoles");
        this.validateRoleURIs(userRoles);
        Validate.notEmpty((CharSequence)project.getId(), (String)"project.id");
        User user = new User(account, userRoles);
        this.doPostProjectUsersUpdate(project, user);
        return this.getUser(project, account);
    }

    private void validateRoleURIs(Role[] userRoles) {
        ArrayList<String> invalidRoles = new ArrayList<String>();
        for (Role role : userRoles) {
            if (role.getUri() != null) continue;
            invalidRoles.add(role.getIdentifier());
        }
        if (!invalidRoles.isEmpty()) {
            throw new IllegalArgumentException("Roles with URI not specified found: " + invalidRoles);
        }
    }

    public void updateUserInProject(Project project, User ... users) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)users, (String)"users");
        Validate.notEmpty((CharSequence)project.getId(), (String)"project.id");
        this.doPostProjectUsersUpdate(project, users);
    }

    private void doPostProjectUsersUpdate(Project project, User ... users) {
        URI usersUri = ProjectService.getUsersUri(project);
        try {
            ProjectUsersUpdateResult projectUsersUpdateResult = (ProjectUsersUpdateResult)this.restTemplate.postForObject(usersUri, (Object)new Users(users), ProjectUsersUpdateResult.class);
            if (!((ProjectUsersUpdateResult)Validate.notNullState((Object)projectUsersUpdateResult, (String)"projectUsersUpdateResult")).getFailed().isEmpty()) {
                throw new ProjectUsersUpdateException("Unable to update users: " + projectUsersUpdateResult.getFailed());
            }
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to update users in project", (Throwable)e);
        }
    }
}

