/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.impl.methods.HttpReport;
import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HttpEntityEnclosingRequest;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.ProtocolException;
import com.gooddata.shadowed.http4.client.methods.HttpEntityEnclosingRequestBase;
import com.gooddata.shadowed.http4.client.methods.HttpUriRequest;
import com.gooddata.shadowed.http4.impl.client.DefaultRedirectStrategy;
import com.gooddata.shadowed.http4.protocol.HttpContext;

public class SardineRedirectStrategy
extends DefaultRedirectStrategy {
    @Override
    protected boolean isRedirectable(String method) {
        if (super.isRedirectable(method)) {
            return true;
        }
        return method.equalsIgnoreCase("PROPFIND");
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("PROPFIND")) {
            HttpPropFind propfind = new HttpPropFind(this.getLocationURI(request, response, context));
            Header depth = request.getFirstHeader("Depth");
            if (depth != null && depth.getValue() != null) {
                propfind.setDepth(depth.getValue());
            }
            return this.copyEntity(propfind, request);
        }
        if (method.equalsIgnoreCase("REPORT")) {
            HttpReport report = new HttpReport(this.getLocationURI(request, response, context));
            Header depth = request.getFirstHeader("Depth");
            if (depth != null && depth.getValue() != null) {
                report.setDepth(depth.getValue());
            }
            return this.copyEntity(report, request);
        }
        return super.getRedirect(request, response, context);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

