/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.auditevent;

import com.gooddata.sdk.common.collections.CustomPageRequest;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.ISOZonedDateTime;
import com.gooddata.sdk.common.util.MutableUri;
import com.gooddata.sdk.common.util.Validate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class TimeFilterPageRequest
extends CustomPageRequest {
    protected ZonedDateTime from;
    protected ZonedDateTime to;

    public static TimeFilterPageRequest copy(TimeFilterPageRequest source) {
        Validate.notNull((Object)((Object)source), (String)"source cannot be null");
        TimeFilterPageRequest copy = new TimeFilterPageRequest();
        BeanUtils.copyProperties((Object)((Object)source), (Object)((Object)copy));
        return copy;
    }

    public ZonedDateTime getFrom() {
        return this.from;
    }

    public void setFrom(ZonedDateTime from) {
        this.from = from;
    }

    public ZonedDateTime getTo() {
        return this.to;
    }

    public void setTo(ZonedDateTime to) {
        this.to = to;
    }

    public TimeFilterPageRequest withIncrementedLimit() {
        TimeFilterPageRequest copy = TimeFilterPageRequest.copy(this);
        copy.setLimit(this.getSanitizedLimit() + 1);
        return copy;
    }

    public MutableUri updateWithPageParams(MutableUri builder) {
        MutableUri builderWithPaging = super.updateWithPageParams(builder);
        if (this.from != null) {
            builderWithPaging.replaceQueryParam("from", new Object[]{ISOZonedDateTime.FORMATTER.format(this.from.withZoneSameInstant(ZoneOffset.UTC))});
        }
        if (this.to != null) {
            builderWithPaging.replaceQueryParam("to", new Object[]{ISOZonedDateTime.FORMATTER.format(this.to.withZoneSameInstant(ZoneOffset.UTC))});
        }
        return builderWithPaging;
    }

    protected boolean canEqual(Object o) {
        return o instanceof TimeFilterPageRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeFilterPageRequest)) {
            return false;
        }
        TimeFilterPageRequest that = (TimeFilterPageRequest)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        if (!that.canEqual((Object)this)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        return Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)((Object)this), (String[])new String[0]);
    }
}

