/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.gdc;

import com.github.sardine.impl.SardineException;
import com.gooddata.sdk.common.GoodDataRestException;
import com.gooddata.sdk.common.UriPrefixer;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.gdc.DataStoreException;
import com.gooddata.sdk.service.gdc.GdcSardine;
import com.gooddata.sdk.service.gdc.GdcSardineResponseHandler;
import com.gooddata.sdk.service.httpcomponents.SingleEndpointGoodDataRestProvider;
import com.gooddata.shadowed.http4.HeaderIterator;
import com.gooddata.shadowed.http4.HttpEntityEnclosingRequest;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.NoHttpResponseException;
import com.gooddata.shadowed.http4.ProtocolVersion;
import com.gooddata.shadowed.http4.StatusLine;
import com.gooddata.shadowed.http4.client.ClientProtocolException;
import com.gooddata.shadowed.http4.client.NonRepeatableRequestException;
import com.gooddata.shadowed.http4.client.methods.CloseableHttpResponse;
import com.gooddata.shadowed.http4.client.methods.HttpUriRequest;
import com.gooddata.shadowed.http4.conn.ClientConnectionManager;
import com.gooddata.shadowed.http4.entity.InputStreamEntity;
import com.gooddata.shadowed.http4.impl.client.CloseableHttpClient;
import com.gooddata.shadowed.http4.impl.client.HttpClientBuilder;
import com.gooddata.shadowed.http4.message.BasicHeader;
import com.gooddata.shadowed.http4.message.BasicHeaderIterator;
import com.gooddata.shadowed.http4.message.BasicStatusLine;
import com.gooddata.shadowed.http4.params.HttpParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class DataStoreService {
    private final GdcSardine sardine;
    private final Supplier<String> stagingUriSupplier;
    private final URI gdcUri;
    private final RestTemplate restTemplate;
    private UriPrefixer prefixer;

    public DataStoreService(SingleEndpointGoodDataRestProvider restProvider, Supplier<String> stagingUriSupplier) {
        Validate.notNull((Object)restProvider, (String)"restProvider");
        this.stagingUriSupplier = (Supplier)Validate.notNull(stagingUriSupplier, (String)"stagingUriSupplier");
        this.gdcUri = URI.create(((GoodDataEndpoint)Validate.notNull((Object)restProvider.getEndpoint(), (String)"endpoint")).toUri());
        this.restTemplate = (RestTemplate)Validate.notNull((Object)restProvider.getRestTemplate(), (String)"restTemplate");
        this.sardine = new GdcSardine(new CustomHttpClientBuilder((HttpClient)Validate.notNull((Object)restProvider.getHttpClient(), (String)"httpClient")));
    }

    private UriPrefixer getPrefixer() {
        if (this.prefixer == null) {
            String uriString = this.stagingUriSupplier.get();
            URI uri = URI.create(uriString);
            this.prefixer = new UriPrefixer(uri.isAbsolute() ? uri : this.gdcUri.resolve(uriString));
            this.sardine.enablePreemptiveAuthentication(this.prefixer.getUriPrefix().getHost());
        }
        return this.prefixer;
    }

    public URI getUri(String path) {
        return this.getPrefixer().mergeUris(path);
    }

    public void upload(String path, InputStream stream) {
        Validate.notEmpty((CharSequence)path, (String)"path");
        Validate.notNull((Object)stream, (String)"stream");
        this.upload(this.getUri(path), stream);
    }

    private void upload(URI url, InputStream stream) {
        try {
            InputStreamEntity entity = new InputStreamEntity(stream);
            List<com.gooddata.shadowed.http4.Header> headers = Collections.singletonList(new BasicHeader("Expect", "100-continue"));
            this.sardine.put(url.toString(), (com.gooddata.shadowed.http4.HttpEntity)entity, headers, new GdcSardineResponseHandler());
        }
        catch (SardineException e) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == e.getStatusCode()) {
                throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
            }
            throw new DataStoreException("Unable to upload to " + String.valueOf(url) + " got status " + e.getStatusCode(), e);
        }
        catch (NoHttpResponseException e) {
            throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof NonRepeatableRequestException) {
                throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
            }
            throw new DataStoreException("Unable to upload to " + String.valueOf(url), e);
        }
    }

    private String createUnAuthRequestWarningMessage(URI url) {
        return "Got 500 while uploading to " + String.valueOf(url) + ".\nThis can be known limitation, see https://github.com/gooddata/gooddata-java/wiki/Known-limitations";
    }

    public InputStream download(String path) {
        Validate.notEmpty((CharSequence)path, (String)"path");
        URI uri = this.getUri(path);
        try {
            return this.sardine.get(uri.toString(), Collections.emptyList(), new GdcSardineResponseHandler());
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to download from " + String.valueOf(uri), e);
        }
    }

    public void delete(String path) {
        Validate.notEmpty((CharSequence)path, (String)"path");
        URI uri = this.getUri(path);
        try {
            ResponseEntity result = this.restTemplate.exchange(uri, HttpMethod.DELETE, HttpEntity.EMPTY, Void.class);
            if (HttpStatus.MOVED_PERMANENTLY.equals((Object)result.getStatusCode())) {
                this.restTemplate.exchange(Objects.requireNonNull(result.getHeaders().getLocation()), HttpMethod.DELETE, HttpEntity.EMPTY, Void.class);
            }
        }
        catch (GoodDataRestException e) {
            throw new DataStoreException("Unable to delete " + String.valueOf(uri), e);
        }
    }

    static class CustomHttpClientBuilder
    extends HttpClientBuilder {
        private final HttpClient client;

        private CustomHttpClientBuilder(HttpClient client) {
            this.client = (HttpClient)Validate.notNull((Object)client, (String)"client");
        }

        @Override
        public CloseableHttpClient build() {
            return new ShadowHttpClient4Adapter(this.client);
        }
    }

    static final class ShadowHttpClient4Adapter
    extends CloseableHttpClient {
        private final HttpClient client;

        private ShadowHttpClient4Adapter(HttpClient client) {
            this.client = client;
        }

        private static HttpContext adaptContext(com.gooddata.shadowed.http4.protocol.HttpContext context) {
            if (context instanceof HttpContext) {
                return (HttpContext)context;
            }
            return null;
        }

        private static HttpHost adaptHost(com.gooddata.shadowed.http4.HttpHost target, HttpRequest request) {
            HttpUriRequest uriRequest;
            URI uri;
            if (target != null) {
                return new HttpHost(target.getSchemeName(), target.getHostName(), target.getPort());
            }
            if (request instanceof HttpUriRequest && (uri = (uriRequest = (HttpUriRequest)request).getURI()).isAbsolute()) {
                return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
            }
            return null;
        }

        private static ClassicHttpRequest adaptRequest(HttpHost target, HttpRequest request) throws IOException {
            com.gooddata.shadowed.http4.HttpEntity entity;
            String method = request.getRequestLine().getMethod();
            URI uri = ShadowHttpClient4Adapter.resolveUri(target, request);
            HttpUriRequestBase builder = new HttpUriRequestBase(method, uri);
            for (com.gooddata.shadowed.http4.Header header : request.getAllHeaders()) {
                builder.addHeader(header.getName(), (Object)header.getValue());
            }
            if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
                builder.setEntity(ShadowHttpClient4Adapter.adaptEntity(entity));
            }
            return builder;
        }

        private static URI resolveUri(HttpHost target, HttpRequest request) {
            if (request instanceof HttpUriRequest) {
                URI requestUri = ((HttpUriRequest)request).getURI();
                if (requestUri.isAbsolute() || target == null) {
                    return requestUri;
                }
                return URI.create(target.toURI()).resolve(requestUri.toString());
            }
            String uri = request.getRequestLine().getUri();
            URI parsed = URI.create(uri);
            if (parsed.isAbsolute() || target == null) {
                return parsed;
            }
            return URI.create(target.toURI()).resolve(uri);
        }

        private static org.apache.hc.core5.http.HttpEntity adaptEntity(com.gooddata.shadowed.http4.HttpEntity entity) throws IOException {
            ContentType contentType = entity.getContentType() != null ? ContentType.parse((CharSequence)entity.getContentType().getValue()) : null;
            return new org.apache.hc.core5.http.io.entity.InputStreamEntity(entity.getContent(), entity.getContentLength(), contentType);
        }

        @Override
        protected CloseableHttpResponse doExecute(com.gooddata.shadowed.http4.HttpHost target, HttpRequest request, com.gooddata.shadowed.http4.protocol.HttpContext context) throws IOException, ClientProtocolException {
            Validate.notNull((Object)request, (String)"request");
            HttpHost target5 = ShadowHttpClient4Adapter.adaptHost(target, request);
            ClassicHttpRequest request5 = ShadowHttpClient4Adapter.adaptRequest(target5, request);
            ClassicHttpResponse response5 = this.execute(target5, request5, context);
            return new ShadowedCloseableHttpResponse(response5);
        }

        private ClassicHttpResponse execute(HttpHost target, ClassicHttpRequest request, com.gooddata.shadowed.http4.protocol.HttpContext context) throws IOException {
            if (target != null) {
                return (ClassicHttpResponse)this.client.execute(target, request, ShadowHttpClient4Adapter.adaptContext(context), response -> response);
            }
            return (ClassicHttpResponse)this.client.execute(request, ShadowHttpClient4Adapter.adaptContext(context), response -> response);
        }

        @Override
        public void close() {
        }

        @Override
        @Deprecated
        public HttpParams getParams() {
            return null;
        }

        @Override
        @Deprecated
        public ClientConnectionManager getConnectionManager() {
            return null;
        }

        static final class ShadowedCloseableHttpResponse
        implements CloseableHttpResponse {
            private final ClassicHttpResponse response;

            private ShadowedCloseableHttpResponse(ClassicHttpResponse response) {
                this.response = (ClassicHttpResponse)Validate.notNull((Object)response, (String)"response");
            }

            private static Header[] convert(com.gooddata.shadowed.http4.Header[] headers) {
                Header[] converted = new Header[headers.length];
                for (int i = 0; i < headers.length; ++i) {
                    converted[i] = new org.apache.hc.core5.http.message.BasicHeader(headers[i].getName(), (Object)headers[i].getValue());
                }
                return converted;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public StatusLine getStatusLine() {
                org.apache.hc.core5.http.ProtocolVersion version = this.response.getVersion();
                ProtocolVersion protocolVersion = new ProtocolVersion(version.getProtocol(), version.getMajor(), version.getMinor());
                return new BasicStatusLine(protocolVersion, this.response.getCode(), this.response.getReasonPhrase());
            }

            @Override
            public void setStatusLine(StatusLine statusline) {
                this.response.setCode(statusline.getStatusCode());
            }

            @Override
            public void setStatusLine(ProtocolVersion ver, int code) {
                this.response.setVersion(new org.apache.hc.core5.http.ProtocolVersion(ver.getProtocol(), ver.getMajor(), ver.getMinor()));
                this.response.setCode(code);
            }

            @Override
            public void setStatusLine(ProtocolVersion ver, int code, String reason) {
                this.setStatusLine(ver, code);
                this.response.setReasonPhrase(reason);
            }

            @Override
            public void setStatusCode(int code) throws IllegalStateException {
                this.response.setCode(code);
            }

            @Override
            public void setReasonPhrase(String reason) throws IllegalStateException {
                this.response.setReasonPhrase(reason);
            }

            @Override
            public com.gooddata.shadowed.http4.HttpEntity getEntity() {
                org.apache.hc.core5.http.HttpEntity entity = this.response.getEntity();
                return entity == null ? null : new ShadowedHttpEntity(entity);
            }

            @Override
            public void setEntity(com.gooddata.shadowed.http4.HttpEntity entity) {
                if (entity == null) {
                    this.response.setEntity(null);
                    return;
                }
                try {
                    this.response.setEntity(ShadowHttpClient4Adapter.adaptEntity(entity));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to set entity on the Sardine shadow response", e);
                }
            }

            @Override
            public Locale getLocale() {
                return Locale.getDefault();
            }

            @Override
            public void setLocale(Locale loc) {
            }

            @Override
            public ProtocolVersion getProtocolVersion() {
                org.apache.hc.core5.http.ProtocolVersion version = this.response.getVersion();
                return new ProtocolVersion(version.getProtocol(), version.getMajor(), version.getMinor());
            }

            @Override
            public boolean containsHeader(String name) {
                return this.response.containsHeader(name);
            }

            @Override
            public com.gooddata.shadowed.http4.Header[] getHeaders(String name) {
                Header[] headers = this.response.getHeaders(name);
                com.gooddata.shadowed.http4.Header[] converted = new com.gooddata.shadowed.http4.Header[headers.length];
                for (int i = 0; i < headers.length; ++i) {
                    converted[i] = new BasicHeader(headers[i].getName(), headers[i].getValue());
                }
                return converted;
            }

            @Override
            public com.gooddata.shadowed.http4.Header getFirstHeader(String name) {
                Header header = this.response.getFirstHeader(name);
                return header == null ? null : new BasicHeader(header.getName(), header.getValue());
            }

            @Override
            public com.gooddata.shadowed.http4.Header getLastHeader(String name) {
                Header header = this.response.getLastHeader(name);
                return header == null ? null : new BasicHeader(header.getName(), header.getValue());
            }

            @Override
            public com.gooddata.shadowed.http4.Header[] getAllHeaders() {
                Header[] headers = this.response.getHeaders();
                com.gooddata.shadowed.http4.Header[] converted = new com.gooddata.shadowed.http4.Header[headers.length];
                for (int i = 0; i < headers.length; ++i) {
                    converted[i] = new BasicHeader(headers[i].getName(), headers[i].getValue());
                }
                return converted;
            }

            @Override
            public void addHeader(com.gooddata.shadowed.http4.Header header) {
                this.response.addHeader(header.getName(), (Object)header.getValue());
            }

            @Override
            public void addHeader(String name, String value) {
                this.response.addHeader(name, (Object)value);
            }

            @Override
            public void setHeader(com.gooddata.shadowed.http4.Header header) {
                this.response.setHeader(header.getName(), (Object)header.getValue());
            }

            @Override
            public void setHeader(String name, String value) {
                this.response.setHeader(name, (Object)value);
            }

            @Override
            public void setHeaders(com.gooddata.shadowed.http4.Header[] headers) {
                this.response.setHeaders(ShadowedCloseableHttpResponse.convert(headers));
            }

            @Override
            public void removeHeader(com.gooddata.shadowed.http4.Header header) {
                this.response.removeHeaders(header.getName());
            }

            @Override
            public void removeHeaders(String name) {
                this.response.removeHeaders(name);
            }

            @Override
            public HeaderIterator headerIterator() {
                return new BasicHeaderIterator(this.getAllHeaders(), null);
            }

            @Override
            public HeaderIterator headerIterator(String name) {
                return new BasicHeaderIterator(this.getHeaders(name), name);
            }

            @Override
            @Deprecated
            public HttpParams getParams() {
                return null;
            }

            @Override
            @Deprecated
            public void setParams(HttpParams params) {
            }
        }

        static final class ShadowedHttpEntity
        implements com.gooddata.shadowed.http4.HttpEntity {
            private final org.apache.hc.core5.http.HttpEntity delegate;

            private ShadowedHttpEntity(org.apache.hc.core5.http.HttpEntity delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean isRepeatable() {
                return this.delegate.isRepeatable();
            }

            @Override
            public boolean isChunked() {
                return this.delegate.isChunked();
            }

            @Override
            public long getContentLength() {
                return this.delegate.getContentLength();
            }

            @Override
            public com.gooddata.shadowed.http4.Header getContentType() {
                String type = this.delegate.getContentType();
                return type == null ? null : new BasicHeader("Content-Type", type);
            }

            @Override
            public com.gooddata.shadowed.http4.Header getContentEncoding() {
                String encoding = this.delegate.getContentEncoding();
                return encoding == null ? null : new BasicHeader("Content-Encoding", encoding);
            }

            @Override
            public InputStream getContent() throws IOException {
                return this.delegate.getContent();
            }

            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                this.delegate.writeTo(outstream);
            }

            @Override
            public boolean isStreaming() {
                return this.delegate.isStreaming();
            }

            @Override
            @Deprecated
            public void consumeContent() throws IOException {
                EntityUtils.consume((org.apache.hc.core5.http.HttpEntity)this.delegate);
            }
        }
    }
}

