/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.gdc;

import com.github.sardine.impl.SardineImpl;
import com.github.sardine.impl.io.ContentLengthInputStream;
import com.github.sardine.impl.io.HttpMethodReleaseInputStream;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.client.ResponseHandler;
import com.gooddata.shadowed.http4.client.methods.HttpGet;
import com.gooddata.shadowed.http4.client.methods.HttpRequestBase;
import com.gooddata.shadowed.http4.impl.client.HttpClientBuilder;
import java.io.IOException;
import java.util.List;

class GdcSardine
extends SardineImpl {
    public GdcSardine(HttpClientBuilder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        Validate.notNull((Object)request, (String)"request");
        try {
            T t = super.execute(request, responseHandler);
            return t;
        }
        finally {
            request.releaseConnection();
        }
    }

    public <T> ContentLengthInputStream get(String url, List<Header> headers, ResponseHandler<T> responseHandler) throws IOException {
        HttpGet get = new HttpGet(url);
        for (Header header : headers) {
            get.addHeader(header);
        }
        HttpResponse response = this.execute(get);
        try {
            responseHandler.handleResponse(response);
            return new ContentLengthInputStream(new HttpMethodReleaseInputStream(response), response.getEntity().getContentLength());
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }
}

