/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.gdc;

import com.github.sardine.impl.SardineException;
import com.gooddata.sdk.service.gdc.GdcSardineException;
import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.StatusLine;
import com.gooddata.shadowed.http4.client.ResponseHandler;
import java.io.IOException;

class GdcSardineResponseHandler
implements ResponseHandler<Void> {
    GdcSardineResponseHandler() {
    }

    @Override
    public Void handleResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return null;
        }
        Header requestIdHeader = response.getFirstHeader("X-GDC-REQUEST");
        if (requestIdHeader != null) {
            throw new GdcSardineException(requestIdHeader.getValue(), "Unexpected response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        throw new SardineException("Unexpected response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
    }
}

