/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.sdk.common.UriPrefixer;
import com.gooddata.sdk.common.util.Validate;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;

class RestTemplateUriPrefixingClientHttpRequestFactory
extends AbstractClientHttpRequestFactoryWrapper {
    private final UriPrefixer prefixer;

    RestTemplateUriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory requestFactory, URI endpointUri) {
        super((ClientHttpRequestFactory)Validate.notNull((Object)requestFactory, (String)"requestFactory"));
        URI apiEndpoint = (URI)Validate.notNull((Object)endpointUri, (String)"endpointUri");
        this.prefixer = new UriPrefixer(apiEndpoint);
    }

    protected ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod, ClientHttpRequestFactory requestFactory) throws IOException {
        URI targetUri = uri.isAbsolute() ? uri : this.prefixer.mergeUris(uri);
        return requestFactory.createRequest(targetUri, httpMethod);
    }
}

