/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.sdk.common.HttpClient5ComponentsClientHttpRequestFactory;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.DeprecationWarningRequestInterceptor;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataRestProvider;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.HeaderSettingRequestInterceptor;
import com.gooddata.sdk.service.RequestIdInterceptor;
import com.gooddata.sdk.service.ResponseMissingRequestIdInterceptor;
import com.gooddata.sdk.service.gdc.DataStoreService;
import com.gooddata.sdk.service.httpcomponents.GoodDataHttpClientBuilder;
import com.gooddata.sdk.service.httpcomponents.RestTemplateUriPrefixingClientHttpRequestFactory;
import com.gooddata.sdk.service.retry.RetryableRestTemplate;
import com.gooddata.sdk.service.util.ResponseErrorHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class SingleEndpointGoodDataRestProvider
implements GoodDataRestProvider {
    protected final GoodDataEndpoint endpoint;
    protected final GoodDataSettings settings;
    private final Logger logger = LoggerFactory.getLogger(SingleEndpointGoodDataRestProvider.class);
    protected HttpClient httpClient;
    protected RestTemplate restTemplate;

    protected SingleEndpointGoodDataRestProvider(GoodDataEndpoint endpoint, GoodDataSettings settings, GoodDataHttpClientBuilder builder) {
        this.endpoint = endpoint;
        this.settings = settings;
        this.restTemplate = this.createRestTemplate(endpoint, settings, builder.buildHttpClient(this.createHttpClientBuilder(settings), endpoint, settings));
    }

    @Override
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Override
    public GoodDataSettings getSettings() {
        return this.settings;
    }

    @Override
    public Optional<DataStoreService> getDataStoreService(Supplier<String> stagingUriSupplier) {
        try {
            Class.forName("com.github.sardine.Sardine", false, this.getClass().getClassLoader());
            return Optional.of(new DataStoreService(this, stagingUriSupplier));
        }
        catch (ClassNotFoundException e) {
            this.logger.info("Optional dependency Sardine not found - WebDAV related operations are not supported");
            return Optional.empty();
        }
    }

    public GoodDataEndpoint getEndpoint() {
        return this.endpoint;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected RestTemplate createRestTemplate(GoodDataEndpoint endpoint, GoodDataSettings settings, HttpClient httpClient) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)settings, (String)"settings");
        this.httpClient = (HttpClient)Validate.notNull((Object)httpClient, (String)"httpClient");
        HttpClient5ComponentsClientHttpRequestFactory httpClientFactory = new HttpClient5ComponentsClientHttpRequestFactory(httpClient);
        RestTemplateUriPrefixingClientHttpRequestFactory factory = new RestTemplateUriPrefixingClientHttpRequestFactory(httpClientFactory, URI.create(endpoint.toUri()));
        RestTemplate restTemplate = settings.getRetrySettings() == null ? new RestTemplate((ClientHttpRequestFactory)factory) : RetryableRestTemplate.create(settings.getRetrySettings(), (ClientHttpRequestFactory)factory);
        restTemplate.setInterceptors(Arrays.asList(new HeaderSettingRequestInterceptor(settings.getPresetHeaders()), new DeprecationWarningRequestInterceptor()));
        restTemplate.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)new ResponseErrorHandler(restTemplate.getMessageConverters()));
        return restTemplate;
    }

    protected HttpClientBuilder createHttpClientBuilder(GoodDataSettings settings) {
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)settings.getSocketTimeout())).build()).setMaxConnPerRoute(settings.getMaxConnections()).setMaxConnTotal(settings.getMaxConnections()).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)settings.getConnectionRequestTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)settings.getSocketTimeout())).setCookieSpec("strict").build();
        return HttpClientBuilder.create().setUserAgent(settings.getGoodDataUserAgent()).setConnectionManager((HttpClientConnectionManager)connectionManager).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestIdInterceptor()).addResponseInterceptorFirst((HttpResponseInterceptor)new ResponseMissingRequestIdInterceptor()).setDefaultRequestConfig(requestConfig);
    }
}

