/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.client.methods;

import com.gooddata.shadowed.http4.ProtocolVersion;
import com.gooddata.shadowed.http4.RequestLine;
import com.gooddata.shadowed.http4.client.config.RequestConfig;
import com.gooddata.shadowed.http4.client.methods.AbstractExecutionAwareRequest;
import com.gooddata.shadowed.http4.client.methods.Configurable;
import com.gooddata.shadowed.http4.client.methods.HttpUriRequest;
import com.gooddata.shadowed.http4.message.BasicRequestLine;
import com.gooddata.shadowed.http4.params.HttpProtocolParams;
import java.net.URI;

public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

