/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.client.protocol;

import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HeaderElement;
import com.gooddata.shadowed.http4.HttpEntity;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.HttpResponseInterceptor;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.client.config.RequestConfig;
import com.gooddata.shadowed.http4.client.entity.DecompressingEntity;
import com.gooddata.shadowed.http4.client.entity.DeflateInputStreamFactory;
import com.gooddata.shadowed.http4.client.entity.GZIPInputStreamFactory;
import com.gooddata.shadowed.http4.client.entity.InputStreamFactory;
import com.gooddata.shadowed.http4.client.protocol.HttpClientContext;
import com.gooddata.shadowed.http4.config.Lookup;
import com.gooddata.shadowed.http4.config.RegistryBuilder;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = ignoreUnknown;
    }

    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, ignoreUnknown);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this(decoderRegistry, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

