/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.conn;

import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.HttpResponseFactory;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.config.MessageConstraints;
import com.gooddata.shadowed.http4.impl.DefaultHttpResponseFactory;
import com.gooddata.shadowed.http4.impl.conn.DefaultHttpResponseParser;
import com.gooddata.shadowed.http4.io.HttpMessageParser;
import com.gooddata.shadowed.http4.io.HttpMessageParserFactory;
import com.gooddata.shadowed.http4.io.SessionInputBuffer;
import com.gooddata.shadowed.http4.message.BasicLineParser;
import com.gooddata.shadowed.http4.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

