/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.cookie;

import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.cookie.CommonCookieAttributeHandler;
import com.gooddata.shadowed.http4.cookie.Cookie;
import com.gooddata.shadowed.http4.cookie.CookieOrigin;
import com.gooddata.shadowed.http4.cookie.MalformedCookieException;
import com.gooddata.shadowed.http4.cookie.SetCookie;
import com.gooddata.shadowed.http4.impl.cookie.AbstractCookieAttributeHandler;
import com.gooddata.shadowed.http4.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

