/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.execchain;

import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.NoHttpResponseException;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.client.HttpRequestRetryHandler;
import com.gooddata.shadowed.http4.client.NonRepeatableRequestException;
import com.gooddata.shadowed.http4.client.methods.CloseableHttpResponse;
import com.gooddata.shadowed.http4.client.methods.HttpExecutionAware;
import com.gooddata.shadowed.http4.client.methods.HttpRequestWrapper;
import com.gooddata.shadowed.http4.client.protocol.HttpClientContext;
import com.gooddata.shadowed.http4.conn.routing.HttpRoute;
import com.gooddata.shadowed.http4.impl.execchain.ClientExecChain;
import com.gooddata.shadowed.http4.impl.execchain.RequestEntityProxy;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryHandler, "HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route, request, context, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    this.log.debug((Object)"Request has been aborted");
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, context)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request to " + route + ": " + ex.getMessage()));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    if (!RequestEntityProxy.isRepeatable(request)) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", ex);
                    }
                    request.setHeaders(origheaders);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Retrying request to " + route));
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                ++execCount;
                continue;
            }
            break;
        }
    }
}

