/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.io;

import com.gooddata.shadowed.http4.Header;
import com.gooddata.shadowed.http4.HeaderIterator;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpMessage;
import com.gooddata.shadowed.http4.io.HttpMessageWriter;
import com.gooddata.shadowed.http4.io.SessionOutputBuffer;
import com.gooddata.shadowed.http4.message.BasicLineFormatter;
import com.gooddata.shadowed.http4.message.LineFormatter;
import com.gooddata.shadowed.http4.params.HttpParams;
import com.gooddata.shadowed.http4.util.Args;
import com.gooddata.shadowed.http4.util.CharArrayBuffer;
import java.io.IOException;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

