/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.protocol;

import com.gooddata.shadowed.http4.HttpEntity;
import com.gooddata.shadowed.http4.HttpEntityEnclosingRequest;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpRequestInterceptor;
import com.gooddata.shadowed.http4.HttpVersion;
import com.gooddata.shadowed.http4.ProtocolVersion;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

