/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.protocol;

import com.gooddata.shadowed.http4.HttpConnection;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpHost;
import com.gooddata.shadowed.http4.HttpInetConnection;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpRequestInterceptor;
import com.gooddata.shadowed.http4.HttpVersion;
import com.gooddata.shadowed.http4.ProtocolException;
import com.gooddata.shadowed.http4.ProtocolVersion;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import com.gooddata.shadowed.http4.protocol.HttpCoreContext;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

