/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.TableId;
import org.junit.Assert;
import org.junit.Test;

public class AclTest {
    @Test
    public void testDomainEntity() {
        Acl.Domain entity = new Acl.Domain("d1");
        Assert.assertEquals((Object)"d1", (Object)entity.domain());
        Assert.assertEquals((Object)Acl.Entity.Type.DOMAIN, (Object)entity.type());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testGroupEntity() {
        Acl.Group entity = new Acl.Group("g1");
        Assert.assertEquals((Object)"g1", (Object)entity.identifier());
        Assert.assertEquals((Object)Acl.Entity.Type.GROUP, (Object)entity.type());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testSpecialGroupEntity() {
        Acl.Group entity = Acl.Group.ofAllAuthenticatedUsers();
        Assert.assertEquals((Object)"allAuthenticatedUsers", (Object)entity.identifier());
        entity = Acl.Group.ofProjectWriters();
        Assert.assertEquals((Object)"projectWriters", (Object)entity.identifier());
        entity = Acl.Group.ofProjectReaders();
        Assert.assertEquals((Object)"projectReaders", (Object)entity.identifier());
        entity = Acl.Group.ofProjectOwners();
        Assert.assertEquals((Object)"projectOwners", (Object)entity.identifier());
    }

    @Test
    public void testUserEntity() {
        Acl.User entity = new Acl.User("u1");
        Assert.assertEquals((Object)"u1", (Object)entity.email());
        Assert.assertEquals((Object)Acl.Entity.Type.USER, (Object)entity.type());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testViewEntity() {
        TableId viewId = TableId.of((String)"project", (String)"dataset", (String)"view");
        Acl.View entity = new Acl.View(viewId);
        Assert.assertEquals((Object)viewId, (Object)entity.id());
        Assert.assertEquals((Object)Acl.Entity.Type.VIEW, (Object)entity.type());
        Dataset.Access pb = entity.toPb();
        Assert.assertEquals((Object)entity, (Object)Acl.Entity.fromPb((Dataset.Access)pb));
    }

    @Test
    public void testOf() {
        Acl acl = Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER);
        Assert.assertEquals((Object)Acl.Group.ofAllAuthenticatedUsers(), (Object)acl.entity());
        Assert.assertEquals((Object)Acl.Role.READER, (Object)acl.role());
        Dataset.Access pb = acl.toPb();
        Assert.assertEquals((Object)acl, (Object)Acl.fromPb((Dataset.Access)pb));
        Acl.View view = new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"view"));
        acl = Acl.of((Acl.View)view);
        Assert.assertEquals((Object)view, (Object)acl.entity());
        Assert.assertEquals(null, (Object)acl.role());
    }
}

