/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.cloud.bigquery.BigQueryError;
import org.junit.Assert;
import org.junit.Test;

public class BigQueryErrorTest {
    private static final String REASON = "reason";
    private static final String LOCATION = "location";
    private static final String DEBUG_INFO = "debugInfo";
    private static final String MESSAGE = "message";
    private static final BigQueryError ERROR = new BigQueryError("reason", "location", "message", "debugInfo");
    private static final BigQueryError ERROR_INCOMPLETE = new BigQueryError("reason", "location", "message");

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)REASON, (Object)ERROR.reason());
        Assert.assertEquals((Object)LOCATION, (Object)ERROR.location());
        Assert.assertEquals((Object)DEBUG_INFO, (Object)ERROR.debugInfo());
        Assert.assertEquals((Object)MESSAGE, (Object)ERROR.message());
        Assert.assertEquals((Object)REASON, (Object)ERROR_INCOMPLETE.reason());
        Assert.assertEquals((Object)LOCATION, (Object)ERROR_INCOMPLETE.location());
        Assert.assertEquals(null, (Object)ERROR_INCOMPLETE.debugInfo());
        Assert.assertEquals((Object)MESSAGE, (Object)ERROR_INCOMPLETE.message());
    }

    @Test
    public void testToAndFromPb() {
        this.compareBigQueryError(ERROR, BigQueryError.fromPb((ErrorProto)ERROR.toPb()));
        this.compareBigQueryError(ERROR_INCOMPLETE, BigQueryError.fromPb((ErrorProto)ERROR_INCOMPLETE.toPb()));
    }

    private void compareBigQueryError(BigQueryError expected, BigQueryError value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.reason(), (Object)value.reason());
        Assert.assertEquals((Object)expected.location(), (Object)value.location());
        Assert.assertEquals((Object)expected.debugInfo(), (Object)value.debugInfo());
        Assert.assertEquals((Object)expected.message(), (Object)value.message());
    }
}

