/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BigQueryExceptionTest {
    @Test
    public void testBigqueryException() {
        BigQueryException exception = new BigQueryException(500, "message");
        Assert.assertEquals((long)500L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new BigQueryException(502, "message");
        Assert.assertEquals((long)502L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new BigQueryException(503, "message");
        Assert.assertEquals((long)503L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new BigQueryException(504, "message");
        Assert.assertEquals((long)504L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new BigQueryException(400, "message");
        Assert.assertEquals((long)400L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertFalse((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        BigQueryError error = new BigQueryError("reason", null, null);
        exception = new BigQueryException(504, "message", error);
        Assert.assertEquals((long)504L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertEquals((Object)"reason", (Object)exception.reason());
        Assert.assertEquals((Object)error, (Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        SocketTimeoutException cause = new SocketTimeoutException("socketTimeoutMessage");
        exception = new BigQueryException((IOException)cause);
        Assert.assertEquals((long)0L, (long)exception.code());
        Assert.assertNull((Object)exception.reason());
        Assert.assertEquals((Object)"socketTimeoutMessage", (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        exception = new BigQueryException(504, "message", (Throwable)cause);
        Assert.assertEquals((long)504L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.error());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        Object cause = new BigQueryException(503, "message");
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn(cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BigQueryException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)503L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertTrue((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
        cause = new IllegalArgumentException("message");
        exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getMessage()).andReturn((Object)"message").times(1);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn(cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BigQueryException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)0L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
                Assert.assertSame((Object)cause, (Object)ex.getCause());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }
}

