/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.Page;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BigQueryImplTest {
    private static final String PROJECT = "project";
    private static final String DATASET = "dataset";
    private static final String TABLE = "table";
    private static final String JOB = "job";
    private static final String OTHER_TABLE = "otherTable";
    private static final String OTHER_DATASET = "otherDataset";
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.Entity)new Acl.View(TableId.of((String)"dataset", (String)"table")), (Acl.Role)Acl.Role.WRITER));
    private static final List<Acl> ACCESS_RULES_WITH_PROJECT = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table"))));
    private static final DatasetInfo DATASET_INFO = DatasetInfo.builder((String)"dataset").acl(ACCESS_RULES).description("description").build();
    private static final DatasetInfo DATASET_INFO_WITH_PROJECT = DatasetInfo.builder((String)"project", (String)"dataset").acl(ACCESS_RULES_WITH_PROJECT).description("description").build();
    private static final DatasetInfo OTHER_DATASET_INFO = DatasetInfo.builder((String)"project", (String)"otherDataset").acl(ACCESS_RULES).description("other description").build();
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final TableId OTHER_TABLE_ID = TableId.of((String)"project", (String)"dataset", (String)"otherTable");
    private static final TableId TABLE_ID_WITH_PROJECT = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final TableInfo OTHER_TABLE_INFO = TableInfo.of((TableId)OTHER_TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final TableInfo TABLE_INFO_WITH_PROJECT = TableInfo.of((TableId)TABLE_ID_WITH_PROJECT, (TableDefinition)TABLE_DEFINITION);
    private static final LoadJobConfiguration LOAD_JOB_CONFIGURATION = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"URI");
    private static final LoadJobConfiguration LOAD_JOB_CONFIGURATION_WITH_PROJECT = LoadJobConfiguration.of((TableId)TABLE_ID_WITH_PROJECT, (String)"URI");
    private static final JobInfo LOAD_JOB = JobInfo.of((JobConfiguration)LOAD_JOB_CONFIGURATION);
    private static final JobInfo COMPLETE_LOAD_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)LOAD_JOB_CONFIGURATION_WITH_PROJECT);
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID, (List)ImmutableList.of((Object)TABLE_ID, (Object)TABLE_ID));
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION_WITH_PROJECT = CopyJobConfiguration.of((TableId)TABLE_ID_WITH_PROJECT, (List)ImmutableList.of((Object)TABLE_ID_WITH_PROJECT, (Object)TABLE_ID_WITH_PROJECT));
    private static final JobInfo COPY_JOB = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final JobInfo COMPLETE_COPY_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)COPY_JOB_CONFIGURATION_WITH_PROJECT);
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.builder((String)"SQL").defaultDataset(DatasetId.of((String)"dataset")).destinationTable(TABLE_ID).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_WITH_PROJECT = QueryJobConfiguration.builder((String)"SQL").defaultDataset(DatasetId.of((String)"project", (String)"dataset")).destinationTable(TABLE_ID_WITH_PROJECT).build();
    private static final JobInfo QUERY_JOB = JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION);
    private static final JobInfo COMPLETE_QUERY_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)QUERY_JOB_CONFIGURATION_WITH_PROJECT);
    private static final ExtractJobConfiguration EXTRACT_JOB_CONFIGURATION = ExtractJobConfiguration.of((TableId)TABLE_ID, (String)"URI");
    private static final ExtractJobConfiguration EXTRACT_JOB_CONFIGURATION_WITH_PROJECT = ExtractJobConfiguration.of((TableId)TABLE_ID_WITH_PROJECT, (String)"URI");
    private static final JobInfo EXTRACT_JOB = JobInfo.of((JobConfiguration)EXTRACT_JOB_CONFIGURATION);
    private static final JobInfo COMPLETE_EXTRACT_JOB = JobInfo.of((JobId)JobId.of((String)"project", (String)"job"), (JobConfiguration)EXTRACT_JOB_CONFIGURATION_WITH_PROJECT);
    private static final TableCell BOOLEAN_FIELD = new TableCell().setV((Object)"false");
    private static final TableCell INTEGER_FIELD = new TableCell().setV((Object)"1");
    private static final TableRow TABLE_ROW = new TableRow().setF((List)ImmutableList.of((Object)BOOLEAN_FIELD, (Object)INTEGER_FIELD));
    private static final QueryRequest QUERY_REQUEST = QueryRequest.builder((String)"SQL").pageSize(Long.valueOf(42L)).useQueryCache(Boolean.valueOf(false)).defaultDataset(DatasetId.of((String)"dataset")).build();
    private static final QueryRequest QUERY_REQUEST_WITH_PROJECT = QueryRequest.builder((String)"SQL").pageSize(Long.valueOf(42L)).useQueryCache(Boolean.valueOf(false)).defaultDataset(DatasetId.of((String)"project", (String)"dataset")).build();
    private static final Map<BigQueryRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final BigQuery.DatasetOption DATASET_OPTION_FIELDS = BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.ACCESS, BigQuery.DatasetField.ETAG});
    private static final BigQuery.DatasetListOption DATASET_LIST_ALL = BigQuery.DatasetListOption.all();
    private static final BigQuery.DatasetListOption DATASET_LIST_PAGE_TOKEN = BigQuery.DatasetListOption.pageToken((String)"cursor");
    private static final BigQuery.DatasetListOption DATASET_LIST_PAGE_SIZE = BigQuery.DatasetListOption.pageSize((long)42L);
    private static final Map<BigQueryRpc.Option, ?> DATASET_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.ALL_DATASETS, (Object)true, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L);
    private static final BigQuery.DatasetDeleteOption DATASET_DELETE_CONTENTS = BigQuery.DatasetDeleteOption.deleteContents();
    private static final Map<BigQueryRpc.Option, ?> DATASET_DELETE_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.DELETE_CONTENTS, (Object)true);
    private static final BigQuery.TableOption TABLE_OPTION_FIELDS = BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.SCHEMA, BigQuery.TableField.ETAG});
    private static final BigQuery.TableListOption TABLE_LIST_PAGE_SIZE = BigQuery.TableListOption.pageSize((long)42L);
    private static final BigQuery.TableListOption TABLE_LIST_PAGE_TOKEN = BigQuery.TableListOption.pageToken((String)"cursor");
    private static final Map<BigQueryRpc.Option, ?> TABLE_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor");
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_PAGE_SIZE = BigQuery.TableDataListOption.pageSize((long)42L);
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_PAGE_TOKEN = BigQuery.TableDataListOption.pageToken((String)"cursor");
    private static final BigQuery.TableDataListOption TABLE_DATA_LIST_START_INDEX = BigQuery.TableDataListOption.startIndex((long)0L);
    private static final Map<BigQueryRpc.Option, ?> TABLE_DATA_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.START_INDEX, (Object)0L);
    private static final BigQuery.JobOption JOB_OPTION_FIELDS = BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.USER_EMAIL});
    private static final BigQuery.JobListOption JOB_LIST_OPTION_FIELD = BigQuery.JobListOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATISTICS});
    private static final BigQuery.JobListOption JOB_LIST_ALL_USERS = BigQuery.JobListOption.allUsers();
    private static final BigQuery.JobListOption JOB_LIST_STATE_FILTER = BigQuery.JobListOption.stateFilter((JobStatus.State[])new JobStatus.State[]{JobStatus.State.DONE, JobStatus.State.PENDING});
    private static final BigQuery.JobListOption JOB_LIST_PAGE_TOKEN = BigQuery.JobListOption.pageToken((String)"cursor");
    private static final BigQuery.JobListOption JOB_LIST_PAGE_SIZE = BigQuery.JobListOption.pageSize((long)42L);
    private static final Map<BigQueryRpc.Option, ?> JOB_LIST_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.ALL_USERS, (Object)true, (Object)BigQueryRpc.Option.STATE_FILTER, (Object)ImmutableList.of((Object)"done", (Object)"pending"), (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)42L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_TIME = BigQuery.QueryResultsOption.maxWaitTime((long)42L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_INDEX = BigQuery.QueryResultsOption.startIndex((long)1024L);
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_PAGE_TOKEN = BigQuery.QueryResultsOption.pageToken((String)"cursor");
    private static final BigQuery.QueryResultsOption QUERY_RESULTS_OPTION_PAGE_SIZE = BigQuery.QueryResultsOption.pageSize((long)0L);
    private static final Map<BigQueryRpc.Option, ?> QUERY_RESULTS_OPTIONS = ImmutableMap.of((Object)BigQueryRpc.Option.TIMEOUT, (Object)42L, (Object)BigQueryRpc.Option.START_INDEX, (Object)1024L, (Object)BigQueryRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)BigQueryRpc.Option.MAX_RESULTS, (Object)0L);
    private BigQueryOptions options;
    private BigQueryRpcFactory rpcFactoryMock;
    private BigQueryRpc bigqueryRpcMock;
    private BigQuery bigquery;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.rpcFactoryMock = (BigQueryRpcFactory)EasyMock.createMock(BigQueryRpcFactory.class);
        this.bigqueryRpcMock = (BigQueryRpc)EasyMock.createMock(BigQueryRpc.class);
        EasyMock.expect((Object)this.rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(BigQueryOptions.class))).andReturn((Object)this.bigqueryRpcMock);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock});
        this.options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.builder().projectId(PROJECT)).serviceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).retryParams(RetryParams.noRetries())).build();
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.bigqueryRpcMock});
    }

    @Test
    public void testGetOptions() {
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertSame((Object)this.options, (Object)this.bigquery.options());
    }

    @Test
    public void testCreateDataset() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(DATASET_INFO_WITH_PROJECT.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.create(DATASET_INFO, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testCreateDatasetWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Dataset)EasyMock.eq((Object)DATASET_INFO_WITH_PROJECT.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.create(DATASET_INFO, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testGetDataset() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testGetDatasetFromDatasetId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.getDataset(DatasetId.of((String)PROJECT, (String)DATASET), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testGetDatasetWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset((String)EasyMock.eq((Object)DATASET), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testListDatasets() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList datasetList = ImmutableList.of((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(OTHER_DATASET_INFO)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)datasetList, (Function)DatasetInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.bigqueryRpcMock.listDatasets(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])datasetList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DatasetInfo.class));
    }

    @Test
    public void testListEmptyDatasets() {
        ImmutableList datasets = ImmutableList.of();
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of(null, (Object)datasets);
        EasyMock.expect((Object)this.bigqueryRpcMock.listDatasets(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])ImmutableList.of().toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Dataset.class));
    }

    @Test
    public void testListDatasetsWithOptions() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList datasetList = ImmutableList.of((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(OTHER_DATASET_INFO)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)datasetList, (Function)DatasetInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.bigqueryRpcMock.listDatasets(DATASET_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listDatasets(new BigQuery.DatasetListOption[]{DATASET_LIST_ALL, DATASET_LIST_PAGE_TOKEN, DATASET_LIST_PAGE_SIZE});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])datasetList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DatasetInfo.class));
    }

    @Test
    public void testDeleteDataset() {
        EasyMock.expect((Object)this.bigqueryRpcMock.deleteDataset(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.delete(DATASET, new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testDeleteDatasetFromDatasetId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.deleteDataset(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.delete(DatasetId.of((String)PROJECT, (String)DATASET), new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testDeleteDatasetWithOptions() {
        EasyMock.expect((Object)this.bigqueryRpcMock.deleteDataset(DATASET, DATASET_DELETE_OPTIONS)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.delete(DATASET, new BigQuery.DatasetDeleteOption[]{DATASET_DELETE_CONTENTS}));
    }

    @Test
    public void testUpdateDataset() {
        DatasetInfo updatedDatasetInfo = DATASET_INFO.toBuilder().description("newDescription").build();
        DatasetInfo updatedDatasetInfoWithProject = DATASET_INFO_WITH_PROJECT.toBuilder().description("newDescription").build();
        EasyMock.expect((Object)this.bigqueryRpcMock.patch(updatedDatasetInfoWithProject.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)updatedDatasetInfoWithProject.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.update(updatedDatasetInfo, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedDatasetInfoWithProject)), (Object)dataset);
    }

    @Test
    public void testUpdateDatasetWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        DatasetInfo updatedDatasetInfo = DATASET_INFO.toBuilder().description("newDescription").build();
        DatasetInfo updatedDatasetInfoWithProject = DATASET_INFO_WITH_PROJECT.toBuilder().description("newDescription").build();
        EasyMock.expect((Object)this.bigqueryRpcMock.patch((com.google.api.services.bigquery.model.Dataset)EasyMock.eq((Object)updatedDatasetInfoWithProject.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)updatedDatasetInfoWithProject.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Dataset dataset = this.bigquery.update(updatedDatasetInfo, new BigQuery.DatasetOption[]{DATASET_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DATASET_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("datasetReference"));
        Assert.assertTrue((boolean)selector.contains("access"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)28L, (long)selector.length());
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedDatasetInfoWithProject)), (Object)dataset);
    }

    @Test
    public void testCreateTable() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(TABLE_INFO_WITH_PROJECT.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.create(TABLE_INFO, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
    }

    @Test
    public void testCreateTableWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Table)EasyMock.eq((Object)TABLE_INFO_WITH_PROJECT.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.create(TABLE_INFO, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
    }

    @Test
    public void testGetTable() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getTable(DATASET, TABLE, EMPTY_RPC_OPTIONS)).andReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.getTable(DATASET, TABLE, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
    }

    @Test
    public void testGetTableFromTableId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getTable(DATASET, TABLE, EMPTY_RPC_OPTIONS)).andReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.getTable(TABLE_ID, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
    }

    @Test
    public void testGetTableWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.bigqueryRpcMock.getTable((String)EasyMock.eq((Object)DATASET), (String)EasyMock.eq((Object)TABLE), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)TABLE_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.getTable(TABLE_ID, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)table);
    }

    @Test
    public void testListTables() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTables(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Table.class));
    }

    @Test
    public void testListTablesFromDatasetId() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTables(DATASET, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listTables(DatasetId.of((String)PROJECT, (String)DATASET), new BigQuery.TableListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Table.class));
    }

    @Test
    public void testListTablesWithOptions() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList tableList = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO_WITH_PROJECT)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(OTHER_TABLE_INFO)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)tableList, (Function)TableInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTables(DATASET, TABLE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listTables(DATASET, new BigQuery.TableListOption[]{TABLE_LIST_PAGE_SIZE, TABLE_LIST_PAGE_TOKEN});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Table.class));
    }

    @Test
    public void testDeleteTable() {
        EasyMock.expect((Object)this.bigqueryRpcMock.deleteTable(DATASET, TABLE)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.delete(DATASET, TABLE));
    }

    @Test
    public void testDeleteTableFromTableId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.deleteTable(DATASET, TABLE)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.delete(TABLE_ID));
    }

    @Test
    public void testUpdateTable() {
        TableInfo updatedTableInfo = TABLE_INFO.toBuilder().description("newDescription").build();
        TableInfo updatedTableInfoWithProject = TABLE_INFO_WITH_PROJECT.toBuilder().description("newDescription").build();
        EasyMock.expect((Object)this.bigqueryRpcMock.patch(updatedTableInfoWithProject.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)updatedTableInfoWithProject.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfoWithProject)), (Object)table);
    }

    @Test
    public void testUpdateTableWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        TableInfo updatedTableInfo = TABLE_INFO.toBuilder().description("newDescription").build();
        TableInfo updatedTableInfoWithProject = TABLE_INFO_WITH_PROJECT.toBuilder().description("newDescription").build();
        EasyMock.expect((Object)this.bigqueryRpcMock.patch((com.google.api.services.bigquery.model.Table)EasyMock.eq((Object)updatedTableInfoWithProject.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)updatedTableInfoWithProject.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Table table = this.bigquery.update(updatedTableInfo, new BigQuery.TableOption[]{TABLE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(TABLE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("tableReference"));
        Assert.assertTrue((boolean)selector.contains("schema"));
        Assert.assertTrue((boolean)selector.contains("etag"));
        Assert.assertEquals((long)31L, (long)selector.length());
        Assert.assertEquals((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(updatedTableInfoWithProject)), (Object)table);
    }

    @Test
    public void testInsertAll() {
        ImmutableMap row1 = ImmutableMap.of((Object)"field", (Object)"value1");
        ImmutableMap row2 = ImmutableMap.of((Object)"field", (Object)"value2");
        ImmutableList rows = ImmutableList.of((Object)new InsertAllRequest.RowToInsert("row1", (Map)row1), (Object)new InsertAllRequest.RowToInsert("row2", (Map)row2));
        InsertAllRequest request = InsertAllRequest.builder((TableId)TABLE_ID).rows((Iterable)rows).skipInvalidRows(false).ignoreUnknownValues(true).templateSuffix("suffix").build();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest().setRows(Lists.transform((List)rows, (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.id()).setJson(rowToInsert.content());
            }
        })).setSkipInvalidRows(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(true)).setTemplateSuffix("suffix");
        TableDataInsertAllResponse responsePb = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setMessage("ErrorMessage")))));
        EasyMock.expect((Object)this.bigqueryRpcMock.insertAll(DATASET, TABLE, requestPb)).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        InsertAllResponse response = this.bigquery.insertAll(request);
        Assert.assertNotNull((Object)response.errorsFor(0L));
        Assert.assertNull((Object)response.errorsFor(1L));
        Assert.assertEquals((long)1L, (long)response.errorsFor(0L).size());
        Assert.assertEquals((Object)"ErrorMessage", (Object)((BigQueryError)response.errorsFor(0L).get(0)).message());
    }

    @Test
    public void testListTableData() {
        String cursor = "cursor";
        TableCell cell1 = new TableCell().setV((Object)"Value1");
        TableCell cell2 = new TableCell().setV((Object)"Value2");
        ImmutableList tableData = ImmutableList.of((Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell1)), (Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell2)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value1"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value2")))));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTableData(DATASET, TABLE, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Page page = this.bigquery.listTableData(DATASET, TABLE, new BigQuery.TableDataListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableData.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), List.class));
    }

    @Test
    public void testListTableDataFromTableId() {
        String cursor = "cursor";
        TableCell cell1 = new TableCell().setV((Object)"Value1");
        TableCell cell2 = new TableCell().setV((Object)"Value2");
        ImmutableList tableData = ImmutableList.of((Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell1)), (Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell2)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value1"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value2")))));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTableData(DATASET, TABLE, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Page page = this.bigquery.listTableData(TableId.of((String)DATASET, (String)TABLE), new BigQuery.TableDataListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableData.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), List.class));
    }

    @Test
    public void testListTableDataWithOptions() {
        String cursor = "cursor";
        TableCell cell1 = new TableCell().setV((Object)"Value1");
        TableCell cell2 = new TableCell().setV((Object)"Value2");
        ImmutableList tableData = ImmutableList.of((Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell1)), (Object)ImmutableList.of((Object)FieldValue.fromPb((Object)cell2)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value1"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value2")))));
        EasyMock.expect((Object)this.bigqueryRpcMock.listTableData(DATASET, TABLE, TABLE_DATA_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Page page = this.bigquery.listTableData(DATASET, TABLE, new BigQuery.TableDataListOption[]{TABLE_DATA_LIST_PAGE_SIZE, TABLE_DATA_LIST_PAGE_TOKEN, TABLE_DATA_LIST_START_INDEX});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])tableData.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), List.class));
    }

    @Test
    public void testCreateQueryJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_WITH_PROJECT).toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_QUERY_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.create(QUERY_JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)job);
    }

    @Test
    public void testCreateLoadJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(JobInfo.of((JobConfiguration)LOAD_JOB_CONFIGURATION_WITH_PROJECT).toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_LOAD_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.create(LOAD_JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)), (Object)job);
    }

    @Test
    public void testCreateCopyJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION_WITH_PROJECT).toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_COPY_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.create(COPY_JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
    }

    @Test
    public void testCreateExtractJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.create(JobInfo.of((JobConfiguration)EXTRACT_JOB_CONFIGURATION_WITH_PROJECT).toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_EXTRACT_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.create(EXTRACT_JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_EXTRACT_JOB)), (Object)job);
    }

    @Test
    public void testCreateJobWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.bigqueryRpcMock.create((com.google.api.services.bigquery.model.Job)EasyMock.eq((Object)JobInfo.of((JobConfiguration)QUERY_JOB_CONFIGURATION_WITH_PROJECT).toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)COMPLETE_QUERY_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.create(QUERY_JOB, new BigQuery.JobOption[]{JOB_OPTION_FIELDS});
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)job);
        String selector = (String)((Map)capturedOptions.getValue()).get(JOB_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("jobReference"));
        Assert.assertTrue((boolean)selector.contains("configuration"));
        Assert.assertTrue((boolean)selector.contains("user_email"));
        Assert.assertEquals((long)37L, (long)selector.length());
    }

    @Test
    public void testGetJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getJob(JOB, EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_COPY_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.getJob(JOB, new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
    }

    @Test
    public void testGetJobFromJobId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getJob(JOB, EMPTY_RPC_OPTIONS)).andReturn((Object)COMPLETE_COPY_JOB.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Job job = this.bigquery.getJob(JobId.of((String)PROJECT, (String)JOB), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_COPY_JOB)), (Object)job);
    }

    @Test
    public void testListJobs() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        EasyMock.expect((Object)this.bigqueryRpcMock.listJobs(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Job.class));
    }

    @Test
    public void testListJobsWithOptions() {
        String cursor = "cursor";
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        EasyMock.expect((Object)this.bigqueryRpcMock.listJobs(JOB_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[]{JOB_LIST_ALL_USERS, JOB_LIST_STATE_FILTER, JOB_LIST_PAGE_TOKEN, JOB_LIST_PAGE_SIZE});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Job.class));
    }

    @Test
    public void testListJobsWithSelectedFields() {
        String cursor = "cursor";
        Capture capturedOptions = Capture.newInstance();
        this.bigquery = (BigQuery)this.options.service();
        ImmutableList jobList = ImmutableList.of((Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_QUERY_JOB)), (Object)new Job(this.bigquery, new JobInfo.BuilderImpl(COMPLETE_LOAD_JOB)));
        BigQueryRpc.Tuple result = BigQueryRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)jobList, (Function)new Function<Job, com.google.api.services.bigquery.model.Job>(){

            public com.google.api.services.bigquery.model.Job apply(Job job) {
                return job.toPb();
            }
        }));
        EasyMock.expect((Object)this.bigqueryRpcMock.listJobs((Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        Page page = this.bigquery.listJobs(new BigQuery.JobListOption[]{JOB_LIST_OPTION_FIELD});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])jobList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Job.class));
        String selector = (String)((Map)capturedOptions.getValue()).get(JOB_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("nextPageToken,jobs("));
        Assert.assertTrue((boolean)selector.contains("configuration"));
        Assert.assertTrue((boolean)selector.contains("jobReference"));
        Assert.assertTrue((boolean)selector.contains("statistics"));
        Assert.assertTrue((boolean)selector.contains("state"));
        Assert.assertTrue((boolean)selector.contains("errorResult"));
        Assert.assertTrue((boolean)selector.contains(")"));
        Assert.assertEquals((long)75L, (long)selector.length());
    }

    @Test
    public void testCancelJob() {
        EasyMock.expect((Object)this.bigqueryRpcMock.cancel(JOB)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.cancel(JOB));
    }

    @Test
    public void testCancelJobFromJobId() {
        EasyMock.expect((Object)this.bigqueryRpcMock.cancel(JOB)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        Assert.assertTrue((boolean)this.bigquery.cancel(JobId.of((String)PROJECT, (String)JOB)));
    }

    @Test
    public void testQueryRequest() {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setJobReference(queryJob.toPb()).setJobComplete(Boolean.valueOf(false));
        EasyMock.expect((Object)this.bigqueryRpcMock.query(QUERY_REQUEST_WITH_PROJECT.toPb())).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        QueryResponse response = this.bigquery.query(QUERY_REQUEST);
        Assert.assertNull((Object)response.etag());
        Assert.assertNull((Object)response.result());
        Assert.assertEquals((Object)queryJob, (Object)response.jobId());
        Assert.assertEquals((Object)false, (Object)response.jobCompleted());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)response.executionErrors());
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals(null, (Object)response.result());
    }

    @Test
    public void testQueryRequestCompleted() {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        com.google.api.services.bigquery.model.QueryResponse responsePb = new com.google.api.services.bigquery.model.QueryResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken("cursor").setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        EasyMock.expect((Object)this.bigqueryRpcMock.query(QUERY_REQUEST_WITH_PROJECT.toPb())).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        QueryResponse response = this.bigquery.query(QUERY_REQUEST);
        Assert.assertNull((Object)response.etag());
        Assert.assertEquals((Object)queryJob, (Object)response.jobId());
        Assert.assertEquals((Object)true, (Object)response.jobCompleted());
        Assert.assertEquals((Object)false, (Object)response.result().cacheHit());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)response.executionErrors());
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals(null, (Object)response.result().schema());
        Assert.assertEquals((long)42L, (long)response.result().totalBytesProcessed());
        Assert.assertEquals((long)1L, (long)response.result().totalRows());
        for (List row : response.result().values()) {
            Assert.assertEquals((Object)false, (Object)((FieldValue)row.get(0)).booleanValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)row.get(1)).longValue());
        }
        Assert.assertEquals((Object)"cursor", (Object)response.result().nextPageCursor());
    }

    @Test
    public void testGetQueryResults() {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setEtag("etag").setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken("cursor").setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        EasyMock.expect((Object)this.bigqueryRpcMock.getQueryResults(JOB, EMPTY_RPC_OPTIONS)).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[0]);
        Assert.assertEquals((Object)"etag", (Object)response.etag());
        Assert.assertEquals((Object)queryJob, (Object)response.jobId());
        Assert.assertEquals((Object)true, (Object)response.jobCompleted());
        Assert.assertEquals((Object)false, (Object)response.result().cacheHit());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)response.executionErrors());
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals(null, (Object)response.result().schema());
        Assert.assertEquals((long)42L, (long)response.result().totalBytesProcessed());
        Assert.assertEquals((long)1L, (long)response.result().totalRows());
        for (List row : response.result().values()) {
            Assert.assertEquals((Object)false, (Object)((FieldValue)row.get(0)).booleanValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)row.get(1)).longValue());
        }
        Assert.assertEquals((Object)"cursor", (Object)response.result().nextPageCursor());
    }

    @Test
    public void testGetQueryResultsWithOptions() {
        JobId queryJob = JobId.of((String)PROJECT, (String)JOB);
        GetQueryResultsResponse responsePb = new GetQueryResultsResponse().setJobReference(queryJob.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken("cursor").setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L));
        EasyMock.expect((Object)this.bigqueryRpcMock.getQueryResults(JOB, QUERY_RESULTS_OPTIONS)).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        QueryResponse response = this.bigquery.getQueryResults(queryJob, new BigQuery.QueryResultsOption[]{QUERY_RESULTS_OPTION_TIME, QUERY_RESULTS_OPTION_INDEX, QUERY_RESULTS_OPTION_PAGE_SIZE, QUERY_RESULTS_OPTION_PAGE_TOKEN});
        Assert.assertEquals((Object)queryJob, (Object)response.jobId());
        Assert.assertEquals((Object)true, (Object)response.jobCompleted());
        Assert.assertEquals((Object)false, (Object)response.result().cacheHit());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)response.executionErrors());
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals(null, (Object)response.result().schema());
        Assert.assertEquals((long)42L, (long)response.result().totalBytesProcessed());
        Assert.assertEquals((long)1L, (long)response.result().totalRows());
        for (List row : response.result().values()) {
            Assert.assertEquals((Object)false, (Object)((FieldValue)row.get(0)).booleanValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)row.get(1)).longValue());
        }
        Assert.assertEquals((Object)"cursor", (Object)response.result().nextPageCursor());
    }

    @Test
    public void testWriter() {
        WriteChannelConfiguration writeChannelConfiguration = WriteChannelConfiguration.of((TableId)TABLE_ID);
        EasyMock.expect((Object)this.bigqueryRpcMock.open(WriteChannelConfiguration.of((TableId)TABLE_ID_WITH_PROJECT).toPb())).andReturn((Object)"upload-id");
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)this.options.service();
        TableDataWriteChannel channel = this.bigquery.writer(writeChannelConfiguration);
        Assert.assertNotNull((Object)channel);
        Assert.assertTrue((boolean)channel.isOpen());
    }

    @Test
    public void testRetryableException() {
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset(DATASET, EMPTY_RPC_OPTIONS)).andThrow((Throwable)new BigQueryException(500, "InternalError")).andReturn((Object)DATASET_INFO_WITH_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        Dataset dataset = this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO_WITH_PROJECT)), (Object)dataset);
    }

    @Test
    public void testNonRetryableException() {
        String exceptionMessage = "Not Implemented";
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset(DATASET, EMPTY_RPC_OPTIONS)).andThrow((Throwable)new BigQueryException(501, exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        this.thrown.expect(BigQueryException.class);
        this.thrown.expectMessage(exceptionMessage);
        this.bigquery.getDataset(DatasetId.of((String)DATASET), new BigQuery.DatasetOption[0]);
    }

    @Test
    public void testRuntimeException() {
        String exceptionMessage = "Artificial runtime exception";
        EasyMock.expect((Object)this.bigqueryRpcMock.getDataset(DATASET, EMPTY_RPC_OPTIONS)).andThrow((Throwable)new RuntimeException(exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        this.thrown.expect(BigQueryException.class);
        this.thrown.expectMessage(exceptionMessage);
        this.bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
    }
}

