/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CopyJobConfigurationTest {
    private static final TableId SOURCE_TABLE = TableId.of((String)"dataset", (String)"sourceTable");
    private static final List<TableId> SOURCE_TABLES = ImmutableList.of((Object)TableId.of((String)"dataset", (String)"sourceTable1"), (Object)TableId.of((String)"dataset", (String)"sourceTable2"));
    private static final TableId DESTINATION_TABLE = TableId.of((String)"dataset", (String)"destinationTable");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.builder((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE).createDisposition(CREATE_DISPOSITION).writeDisposition(WRITE_DISPOSITION).build();
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION_MULTIPLE_TABLES = CopyJobConfiguration.builder((TableId)DESTINATION_TABLE, SOURCE_TABLES).createDisposition(CREATE_DISPOSITION).writeDisposition(WRITE_DISPOSITION).build();

    @Test
    public void testToBuilder() {
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, COPY_JOB_CONFIGURATION.toBuilder().build());
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION_MULTIPLE_TABLES, COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toBuilder().build());
        CopyJobConfiguration jobConfiguration = COPY_JOB_CONFIGURATION.toBuilder().destinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)jobConfiguration.destinationTable().table());
        jobConfiguration = jobConfiguration.toBuilder().destinationTable(DESTINATION_TABLE).build();
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, jobConfiguration);
    }

    @Test
    public void testOf() {
        CopyJobConfiguration job = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)job.destinationTable());
        Assert.assertEquals(SOURCE_TABLES, (Object)job.sourceTables());
        job = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE);
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)job.destinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)SOURCE_TABLE), (Object)job.sourceTables());
    }

    @Test
    public void testToBuilderIncomplete() {
        CopyJobConfiguration jobConfiguration = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        this.compareCopyJobConfiguration(jobConfiguration, jobConfiguration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.destinationTable());
        Assert.assertEquals(SOURCE_TABLES, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.sourceTables());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.createDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.writeDisposition());
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)COPY_JOB_CONFIGURATION.destinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)SOURCE_TABLE), (Object)COPY_JOB_CONFIGURATION.sourceTables());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION.createDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION.writeDisposition());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getLoad());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getQuery());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getCopy().getSourceTables());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toPb().getCopy().getSourceTable());
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, CopyJobConfiguration.fromPb((JobConfiguration)COPY_JOB_CONFIGURATION.toPb()));
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION_MULTIPLE_TABLES, CopyJobConfiguration.fromPb((JobConfiguration)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toPb()));
        CopyJobConfiguration jobConfiguration = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        this.compareCopyJobConfiguration(jobConfiguration, CopyJobConfiguration.fromPb((JobConfiguration)jobConfiguration.toPb()));
    }

    @Test
    public void testSetProjectId() {
        CopyJobConfiguration configuration = COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)configuration.destinationTable().project());
        for (TableId sourceTable : configuration.sourceTables()) {
            Assert.assertEquals((Object)"p", (Object)sourceTable.project());
        }
    }

    private void compareCopyJobConfiguration(CopyJobConfiguration expected, CopyJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.destinationTable(), (Object)value.destinationTable());
        Assert.assertEquals((Object)expected.sourceTables(), (Object)value.sourceTables());
        Assert.assertEquals((Object)expected.createDisposition(), (Object)value.createDisposition());
        Assert.assertEquals((Object)expected.writeDisposition(), (Object)value.writeDisposition());
    }
}

