/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.CsvOptions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class CsvOptionsTest {
    private static final Boolean ALLOW_JAGGED_ROWS = true;
    private static final Boolean ALLOW_QUOTED_NEWLINE = true;
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String FIELD_DELIMITER = ",";
    private static final String QUOTE = "\"";
    private static final Integer SKIP_LEADING_ROWS = 42;
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().allowJaggedRows(ALLOW_JAGGED_ROWS).allowQuotedNewLines(ALLOW_QUOTED_NEWLINE).encoding(ENCODING).fieldDelimiter(",").quote("\"").skipLeadingRows(SKIP_LEADING_ROWS).build();

    @Test
    public void testToBuilder() {
        this.compareCsvOptions(CSV_OPTIONS, CSV_OPTIONS.toBuilder().build());
        CsvOptions csvOptions = CSV_OPTIONS.toBuilder().fieldDelimiter(";").build();
        Assert.assertEquals((Object)";", (Object)csvOptions.fieldDelimiter());
        csvOptions = csvOptions.toBuilder().fieldDelimiter(FIELD_DELIMITER).build();
        this.compareCsvOptions(CSV_OPTIONS, csvOptions);
    }

    @Test
    public void testToBuilderIncomplete() {
        CsvOptions csvOptions = CsvOptions.builder().fieldDelimiter("|").build();
        Assert.assertEquals((Object)csvOptions, (Object)csvOptions.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"CSV", (Object)CSV_OPTIONS.type());
        Assert.assertEquals((Object)ALLOW_JAGGED_ROWS, (Object)CSV_OPTIONS.allowJaggedRows());
        Assert.assertEquals((Object)ALLOW_QUOTED_NEWLINE, (Object)CSV_OPTIONS.allowQuotedNewLines());
        Assert.assertEquals((Object)ENCODING.name(), (Object)CSV_OPTIONS.encoding());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)CSV_OPTIONS.fieldDelimiter());
        Assert.assertEquals((Object)QUOTE, (Object)CSV_OPTIONS.quote());
        Assert.assertEquals((Object)SKIP_LEADING_ROWS, (Object)CSV_OPTIONS.skipLeadingRows());
    }

    @Test
    public void testToAndFromPb() {
        this.compareCsvOptions(CSV_OPTIONS, CsvOptions.fromPb((com.google.api.services.bigquery.model.CsvOptions)CSV_OPTIONS.toPb()));
        CsvOptions csvOptions = CsvOptions.builder().allowJaggedRows(ALLOW_JAGGED_ROWS).build();
        this.compareCsvOptions(csvOptions, CsvOptions.fromPb((com.google.api.services.bigquery.model.CsvOptions)csvOptions.toPb()));
    }

    private void compareCsvOptions(CsvOptions expected, CsvOptions value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.allowJaggedRows(), (Object)value.allowJaggedRows());
        Assert.assertEquals((Object)expected.allowQuotedNewLines(), (Object)value.allowQuotedNewLines());
        Assert.assertEquals((Object)expected.encoding(), (Object)value.encoding());
        Assert.assertEquals((Object)expected.fieldDelimiter(), (Object)value.fieldDelimiter());
        Assert.assertEquals((Object)expected.quote(), (Object)value.quote());
        Assert.assertEquals((Object)expected.skipLeadingRows(), (Object)value.skipLeadingRows());
    }
}

