/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.DatasetReference;
import com.google.cloud.bigquery.DatasetId;
import org.junit.Assert;
import org.junit.Test;

public class DatasetIdTest {
    private static final DatasetId DATASET = DatasetId.of((String)"dataset");
    private static final DatasetId DATASET_COMPLETE = DatasetId.of((String)"project", (String)"dataset");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)DATASET.project());
        Assert.assertEquals((Object)"dataset", (Object)DATASET.dataset());
        Assert.assertEquals((Object)"project", (Object)DATASET_COMPLETE.project());
        Assert.assertEquals((Object)"dataset", (Object)DATASET_COMPLETE.dataset());
    }

    @Test
    public void testEquals() {
        this.compareDatasetIds(DATASET, DatasetId.of((String)"dataset"));
        this.compareDatasetIds(DATASET_COMPLETE, DatasetId.of((String)"project", (String)"dataset"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareDatasetIds(DATASET, DatasetId.fromPb((DatasetReference)DATASET.toPb()));
        this.compareDatasetIds(DATASET_COMPLETE, DatasetId.fromPb((DatasetReference)DATASET_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)DATASET_COMPLETE, (Object)DATASET.setProjectId("project"));
    }

    private void compareDatasetIds(DatasetId expected, DatasetId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)value.project());
        Assert.assertEquals((Object)expected.dataset(), (Object)value.dataset());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

