/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DatasetInfoTest {
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"dataset", (String)"table"))));
    private static final List<Acl> ACCESS_RULES_COMPLETE = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table"))));
    private static final Long CREATION_TIME = System.currentTimeMillis();
    private static final Long DEFAULT_TABLE_EXPIRATION = CREATION_TIME + 100L;
    private static final String DESCRIPTION = "description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final DatasetId DATASET_ID_COMPLETE = DatasetId.of((String)"project", (String)"dataset");
    private static final DatasetInfo DATASET_INFO = DatasetInfo.builder((DatasetId)DATASET_ID).acl(ACCESS_RULES).creationTime(CREATION_TIME).defaultTableLifetime(DEFAULT_TABLE_EXPIRATION).description("description").etag("0xFF00").friendlyName("friendlyDataset").generatedId("P/D:1").lastModified(LAST_MODIFIED).location("").selfLink("http://bigquery/p/d").build();
    private static final DatasetInfo DATASET_INFO_COMPLETE = DATASET_INFO.toBuilder().datasetId(DATASET_ID_COMPLETE).acl(ACCESS_RULES_COMPLETE).build();

    @Test
    public void testToBuilder() {
        this.compareDatasets(DATASET_INFO, DATASET_INFO.toBuilder().build());
        DatasetInfo datasetInfo = DATASET_INFO.toBuilder().datasetId(DatasetId.of((String)"dataset2")).description("description2").build();
        Assert.assertEquals((Object)DatasetId.of((String)"dataset2"), (Object)datasetInfo.datasetId());
        Assert.assertEquals((Object)"description2", (Object)datasetInfo.description());
        datasetInfo = datasetInfo.toBuilder().datasetId(DATASET_ID).description(DESCRIPTION).build();
        this.compareDatasets(DATASET_INFO, datasetInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        DatasetInfo datasetInfo = DatasetInfo.builder((DatasetId)DATASET_ID).build();
        Assert.assertEquals((Object)datasetInfo, (Object)datasetInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertNull((Object)DATASET_INFO.datasetId().project());
        Assert.assertEquals((Object)DATASET_ID, (Object)DATASET_INFO.datasetId());
        Assert.assertEquals(ACCESS_RULES, (Object)DATASET_INFO.acl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)DATASET_INFO.creationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)DATASET_INFO.defaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DATASET_INFO.description());
        Assert.assertEquals((Object)ETAG, (Object)DATASET_INFO.etag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)DATASET_INFO.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)DATASET_INFO.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)DATASET_INFO.lastModified());
        Assert.assertEquals((Object)LOCATION, (Object)DATASET_INFO.location());
        Assert.assertEquals((Object)SELF_LINK, (Object)DATASET_INFO.selfLink());
        Assert.assertEquals((Object)DATASET_ID_COMPLETE, (Object)DATASET_INFO_COMPLETE.datasetId());
        Assert.assertEquals(ACCESS_RULES_COMPLETE, (Object)DATASET_INFO_COMPLETE.acl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)DATASET_INFO_COMPLETE.creationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)DATASET_INFO_COMPLETE.defaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DATASET_INFO_COMPLETE.description());
        Assert.assertEquals((Object)ETAG, (Object)DATASET_INFO_COMPLETE.etag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)DATASET_INFO_COMPLETE.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)DATASET_INFO_COMPLETE.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)DATASET_INFO_COMPLETE.lastModified());
        Assert.assertEquals((Object)LOCATION, (Object)DATASET_INFO_COMPLETE.location());
        Assert.assertEquals((Object)SELF_LINK, (Object)DATASET_INFO_COMPLETE.selfLink());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareDatasets(DATASET_INFO_COMPLETE, DatasetInfo.fromPb((Dataset)DATASET_INFO_COMPLETE.toPb()));
        DatasetInfo datasetInfo = DatasetInfo.builder((String)"project", (String)"dataset").build();
        this.compareDatasets(datasetInfo, DatasetInfo.fromPb((Dataset)datasetInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)DATASET_INFO_COMPLETE, (Object)DATASET_INFO.setProjectId("project"));
    }

    private void compareDatasets(DatasetInfo expected, DatasetInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.datasetId(), (Object)value.datasetId());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.friendlyName(), (Object)value.friendlyName());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.location(), (Object)value.location());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.acl(), (Object)value.acl());
        Assert.assertEquals((Object)expected.creationTime(), (Object)value.creationTime());
        Assert.assertEquals((Object)expected.defaultTableLifetime(), (Object)value.defaultTableLifetime());
        Assert.assertEquals((Object)expected.lastModified(), (Object)value.lastModified());
    }
}

