/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DatasetTest {
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"dataset", (String)"table"))));
    private static final Long CREATION_TIME = System.currentTimeMillis();
    private static final Long DEFAULT_TABLE_EXPIRATION = CREATION_TIME + 100L;
    private static final String DESCRIPTION = "description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetInfo DATASET_INFO = DatasetInfo.builder((DatasetId)DATASET_ID).build();
    private static final Field FIELD = Field.of((String)"FieldName", (Field.Type)Field.Type.integer());
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{FIELD}));
    private static final ViewDefinition VIEW_DEFINITION = ViewDefinition.of((String)"QUERY");
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.of((List)ImmutableList.of((Object)"URI"), (Schema)Schema.of((Field[])new Field[0]), (FormatOptions)FormatOptions.csv());
    private static final TableInfo TABLE_INFO1 = TableInfo.builder((TableId)TableId.of((String)"dataset", (String)"table1"), (TableDefinition)TABLE_DEFINITION).build();
    private static final TableInfo TABLE_INFO2 = TableInfo.builder((TableId)TableId.of((String)"dataset", (String)"table2"), (TableDefinition)VIEW_DEFINITION).build();
    private static final TableInfo TABLE_INFO3 = TableInfo.builder((TableId)TableId.of((String)"dataset", (String)"table3"), (TableDefinition)EXTERNAL_TABLE_DEFINITION).build();
    private BigQuery serviceMockReturnsOptions = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
    private BigQueryOptions mockOptions = (BigQueryOptions)EasyMock.createMock(BigQueryOptions.class);
    private BigQuery bigquery;
    private Dataset expectedDataset;
    private Dataset dataset;

    private void initializeExpectedDataset(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.bigquery = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
        this.expectedDataset = new Dataset(this.serviceMockReturnsOptions, new DatasetInfo.BuilderImpl(DATASET_INFO));
    }

    private void initializeDataset() {
        this.dataset = new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.bigquery, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedDataset(2);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Dataset builtDataset = new Dataset.Builder(this.serviceMockReturnsOptions, DATASET_ID).acl(ACCESS_RULES).creationTime(CREATION_TIME).defaultTableLifetime(DEFAULT_TABLE_EXPIRATION).description(DESCRIPTION).etag(ETAG).friendlyName(FRIENDLY_NAME).generatedId(GENERATED_ID).lastModified(LAST_MODIFIED).location(LOCATION).selfLink(SELF_LINK).build();
        Assert.assertEquals((Object)DATASET_ID, (Object)builtDataset.datasetId());
        Assert.assertEquals(ACCESS_RULES, (Object)builtDataset.acl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)builtDataset.creationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)builtDataset.defaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)builtDataset.description());
        Assert.assertEquals((Object)ETAG, (Object)builtDataset.etag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)builtDataset.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtDataset.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)builtDataset.lastModified());
        Assert.assertEquals((Object)LOCATION, (Object)builtDataset.location());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtDataset.selfLink());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedDataset(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareDataset(this.expectedDataset, this.expectedDataset.toBuilder().build());
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedDataset(1);
        BigQuery.DatasetOption[] expectedOptions = new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getDataset(DATASET_INFO.datasetId(), expectedOptions)).andReturn((Object)this.expectedDataset);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertTrue((boolean)this.dataset.exists());
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedDataset(1);
        BigQuery.DatasetOption[] expectedOptions = new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getDataset(DATASET_INFO.datasetId(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertFalse((boolean)this.dataset.exists());
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedDataset(4);
        DatasetInfo updatedInfo = DATASET_INFO.toBuilder().description("Description").build();
        Dataset expectedDataset = new Dataset(this.serviceMockReturnsOptions, new DatasetInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getDataset(DATASET_INFO.datasetId().dataset(), new BigQuery.DatasetOption[0])).andReturn((Object)expectedDataset);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Dataset updatedDataset = this.dataset.reload(new BigQuery.DatasetOption[0]);
        this.compareDataset(expectedDataset, updatedDataset);
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedDataset(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getDataset(DATASET_INFO.datasetId().dataset(), new BigQuery.DatasetOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertNull((Object)this.dataset.reload(new BigQuery.DatasetOption[0]));
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedDataset(4);
        DatasetInfo updatedInfo = DATASET_INFO.toBuilder().description("Description").build();
        Dataset expectedDataset = new Dataset(this.serviceMockReturnsOptions, new DatasetInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getDataset(DATASET_INFO.datasetId().dataset(), new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])})).andReturn((Object)expectedDataset);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Dataset updatedDataset = this.dataset.reload(new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])});
        this.compareDataset(expectedDataset, updatedDataset);
    }

    @Test
    public void testUpdate() {
        this.initializeExpectedDataset(4);
        Dataset expectedUpdatedDataset = this.expectedDataset.toBuilder().description("Description").build();
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.update((DatasetInfo)EasyMock.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[0])).andReturn((Object)expectedUpdatedDataset);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Dataset actualUpdatedDataset = this.dataset.update(new BigQuery.DatasetOption[0]);
        this.compareDataset(expectedUpdatedDataset, actualUpdatedDataset);
    }

    @Test
    public void testUpdateWithOptions() {
        this.initializeExpectedDataset(4);
        Dataset expectedUpdatedDataset = this.expectedDataset.toBuilder().description("Description").build();
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.update((DatasetInfo)EasyMock.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[]{(BigQuery.DatasetOption)EasyMock.eq((Object)BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0]))})).andReturn((Object)expectedUpdatedDataset);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Dataset actualUpdatedDataset = this.dataset.update(new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])});
        this.compareDataset(expectedUpdatedDataset, actualUpdatedDataset);
    }

    @Test
    public void testDeleteTrue() {
        this.initializeExpectedDataset(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.delete(DATASET_INFO.datasetId(), new BigQuery.DatasetDeleteOption[0])).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertTrue((boolean)this.dataset.delete());
    }

    @Test
    public void testDeleteFalse() {
        this.initializeExpectedDataset(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.delete(DATASET_INFO.datasetId(), new BigQuery.DatasetDeleteOption[0])).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertFalse((boolean)this.dataset.delete());
    }

    @Test
    public void testList() throws Exception {
        this.initializeExpectedDataset(4);
        ImmutableList tableResults = ImmutableList.of((Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1)), (Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO2)), (Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO3)));
        PageImpl expectedPage = new PageImpl(null, "c", (Iterable)tableResults);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.listTables(DATASET_INFO.datasetId(), new BigQuery.TableListOption[0])).andReturn((Object)expectedPage);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Page tablePage = this.dataset.list(new BigQuery.TableListOption[0]);
        Assert.assertArrayEquals((Object[])tableResults.toArray(), (Object[])Iterables.toArray((Iterable)tablePage.values(), Table.class));
        Assert.assertEquals((Object)expectedPage.nextPageCursor(), (Object)tablePage.nextPageCursor());
    }

    @Test
    public void testListWithOptions() throws Exception {
        this.initializeExpectedDataset(4);
        ImmutableList tableResults = ImmutableList.of((Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1)), (Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO2)), (Object)new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO3)));
        PageImpl expectedPage = new PageImpl(null, "c", (Iterable)tableResults);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.listTables(DATASET_INFO.datasetId(), new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10L)})).andReturn((Object)expectedPage);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Page tablePage = this.dataset.list(new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10L)});
        Assert.assertArrayEquals((Object[])tableResults.toArray(), (Object[])Iterables.toArray((Iterable)tablePage.values(), Table.class));
        Assert.assertEquals((Object)expectedPage.nextPageCursor(), (Object)tablePage.nextPageCursor());
    }

    @Test
    public void testGet() throws Exception {
        this.initializeExpectedDataset(2);
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO1.tableId(), new BigQuery.TableOption[0])).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Table table = this.dataset.get(TABLE_INFO1.tableId().table(), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)expectedTable, (Object)table);
    }

    @Test
    public void testGetNull() throws Exception {
        this.initializeExpectedDataset(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO1.tableId(), new BigQuery.TableOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Assert.assertNull((Object)this.dataset.get(TABLE_INFO1.tableId().table(), new BigQuery.TableOption[0]));
    }

    @Test
    public void testGetWithOptions() throws Exception {
        this.initializeExpectedDataset(2);
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO1.tableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Table table = this.dataset.get(TABLE_INFO1.tableId().table(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)expectedTable, (Object)table);
    }

    @Test
    public void testCreateTable() throws Exception {
        this.initializeExpectedDataset(2);
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.create(TABLE_INFO1, new BigQuery.TableOption[0])).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Table table = this.dataset.create(TABLE_INFO1.tableId().table(), (TableDefinition)TABLE_DEFINITION, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)expectedTable, (Object)table);
    }

    @Test
    public void testCreateTableWithOptions() throws Exception {
        this.initializeExpectedDataset(2);
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO1));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.create(TABLE_INFO1, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeDataset();
        Table table = this.dataset.create(TABLE_INFO1.tableId().table(), (TableDefinition)TABLE_DEFINITION, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        Assert.assertEquals((Object)expectedTable, (Object)table);
    }

    @Test
    public void testBigquery() {
        this.initializeExpectedDataset(1);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedDataset.bigquery());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedDataset(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareDataset(this.expectedDataset, Dataset.fromPb((BigQuery)this.serviceMockReturnsOptions, (com.google.api.services.bigquery.model.Dataset)this.expectedDataset.toPb()));
    }

    private void compareDataset(Dataset expected, Dataset value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareDatasetInfo((DatasetInfo)expected, (DatasetInfo)value);
        Assert.assertEquals((Object)expected.bigquery().options(), (Object)value.bigquery().options());
    }

    private void compareDatasetInfo(DatasetInfo expected, DatasetInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.datasetId(), (Object)value.datasetId());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.friendlyName(), (Object)value.friendlyName());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.location(), (Object)value.location());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.acl(), (Object)value.acl());
        Assert.assertEquals((Object)expected.creationTime(), (Object)value.creationTime());
        Assert.assertEquals((Object)expected.defaultTableLifetime(), (Object)value.defaultTableLifetime());
        Assert.assertEquals((Object)expected.lastModified(), (Object)value.lastModified());
    }
}

