/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTableDefinitionTest {
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().build();
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).compression("GZIP").ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).build();

    @Test
    public void testToBuilder() {
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, EXTERNAL_TABLE_DEFINITION.toBuilder().build());
        ExternalTableDefinition externalTableDefinition = EXTERNAL_TABLE_DEFINITION.toBuilder().compression("NONE").build();
        Assert.assertEquals((Object)"NONE", (Object)externalTableDefinition.compression());
        externalTableDefinition = externalTableDefinition.toBuilder().compression(COMPRESSION).build();
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, externalTableDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json());
        Assert.assertEquals((Object)externalTableDefinition, (Object)externalTableDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TableDefinition.Type.EXTERNAL, (Object)EXTERNAL_TABLE_DEFINITION.type());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTERNAL_TABLE_DEFINITION.compression());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)EXTERNAL_TABLE_DEFINITION.formatOptions());
        Assert.assertEquals((Object)IGNORE_UNKNOWN_VALUES, (Object)EXTERNAL_TABLE_DEFINITION.ignoreUnknownValues());
        Assert.assertEquals((Object)MAX_BAD_RECORDS, (Object)EXTERNAL_TABLE_DEFINITION.maxBadRecords());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)EXTERNAL_TABLE_DEFINITION.schema());
        Assert.assertEquals(SOURCE_URIS, (Object)EXTERNAL_TABLE_DEFINITION.sourceUris());
    }

    @Test
    public void testToAndFromPb() {
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, ExternalTableDefinition.fromPb((Table)EXTERNAL_TABLE_DEFINITION.toPb()));
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).build();
        this.compareExternalTableDefinition(externalTableDefinition, ExternalTableDefinition.fromPb((Table)externalTableDefinition.toPb()));
    }

    private void compareExternalTableDefinition(ExternalTableDefinition expected, ExternalTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compression(), (Object)value.compression());
        Assert.assertEquals((Object)expected.formatOptions(), (Object)value.formatOptions());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.maxBadRecords(), (Object)value.maxBadRecords());
        Assert.assertEquals((Object)expected.schema(), (Object)value.schema());
        Assert.assertEquals((Object)expected.sourceUris(), (Object)value.sourceUris());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

