/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ExtractJobConfigurationTest {
    private static final List<String> DESTINATION_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final String DESTINATION_URI = "uri1";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final String FIELD_DELIMITER = ",";
    private static final String FORMAT = "CSV";
    private static final String JSON_FORMAT = "NEWLINE_DELIMITED_JSON";
    private static final Boolean PRINT_HEADER = true;
    private static final String COMPRESSION = "GZIP";
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION = ExtractJobConfiguration.builder((TableId)TABLE_ID, DESTINATION_URIS).printHeader(PRINT_HEADER).fieldDelimiter(",").compression("GZIP").format("CSV").build();
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION_ONE_URI = ExtractJobConfiguration.builder((TableId)TABLE_ID, (String)"uri1").printHeader(PRINT_HEADER).fieldDelimiter(",").compression("GZIP").format("CSV").build();

    @Test
    public void testToBuilder() {
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, EXTRACT_CONFIGURATION.toBuilder().build());
        ExtractJobConfiguration job = EXTRACT_CONFIGURATION.toBuilder().sourceTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)job.sourceTable().table());
        job = job.toBuilder().sourceTable(TABLE_ID).build();
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, job);
    }

    @Test
    public void testOf() {
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.sourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)job.destinationUris());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, (String)DESTINATION_URI);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.sourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)job.destinationUris());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS, (String)JSON_FORMAT);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.sourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)job.destinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)job.format());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, (String)DESTINATION_URI, (String)JSON_FORMAT);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.sourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)job.destinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)job.format());
    }

    @Test
    public void testToBuilderIncomplete() {
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(job, job.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTRACT_CONFIGURATION.sourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)EXTRACT_CONFIGURATION.destinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION.fieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION.compression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION.printHeader());
        Assert.assertEquals((Object)FORMAT, (Object)EXTRACT_CONFIGURATION.format());
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTRACT_CONFIGURATION_ONE_URI.sourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)EXTRACT_CONFIGURATION_ONE_URI.destinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION_ONE_URI.fieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION_ONE_URI.compression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION_ONE_URI.printHeader());
        Assert.assertEquals((Object)FORMAT, (Object)EXTRACT_CONFIGURATION_ONE_URI.format());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)EXTRACT_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getLoad());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getQuery());
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, ExtractJobConfiguration.fromPb((JobConfiguration)EXTRACT_CONFIGURATION.toPb()));
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_ONE_URI, ExtractJobConfiguration.fromPb((JobConfiguration)EXTRACT_CONFIGURATION_ONE_URI.toPb()));
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(job, ExtractJobConfiguration.fromPb((JobConfiguration)job.toPb()));
    }

    @Test
    public void testSetProjectId() {
        ExtractJobConfiguration configuration = EXTRACT_CONFIGURATION.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)configuration.sourceTable().project());
    }

    private void compareExtractJobConfiguration(ExtractJobConfiguration expected, ExtractJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.sourceTable(), (Object)value.sourceTable());
        Assert.assertEquals((Object)expected.destinationUris(), (Object)value.destinationUris());
        Assert.assertEquals((Object)expected.compression(), (Object)value.compression());
        Assert.assertEquals((Object)expected.printHeader(), (Object)value.printHeader());
        Assert.assertEquals((Object)expected.fieldDelimiter(), (Object)value.fieldDelimiter());
        Assert.assertEquals((Object)expected.format(), (Object)value.format());
    }
}

