/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.bigquery.Field;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FieldTest {
    private static final String FIELD_NAME1 = "StringField";
    private static final String FIELD_NAME2 = "IntegerField";
    private static final String FIELD_NAME3 = "RecordField";
    private static final Field.Type FIELD_TYPE1 = Field.Type.string();
    private static final Field.Type FIELD_TYPE2 = Field.Type.integer();
    private static final Field.Mode FIELD_MODE1 = Field.Mode.NULLABLE;
    private static final Field.Mode FIELD_MODE2 = Field.Mode.REPEATED;
    private static final Field.Mode FIELD_MODE3 = Field.Mode.REQUIRED;
    private static final String FIELD_DESCRIPTION1 = "FieldDescription1";
    private static final String FIELD_DESCRIPTION2 = "FieldDescription2";
    private static final String FIELD_DESCRIPTION3 = "FieldDescription3";
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)FIELD_TYPE1).mode(FIELD_MODE1).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)FIELD_TYPE2).mode(FIELD_MODE2).description("FieldDescription2").build();
    private static final Field.Type FIELD_TYPE3 = Field.Type.record((List)ImmutableList.of((Object)FIELD_SCHEMA1, (Object)FIELD_SCHEMA2));
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)FIELD_TYPE3).mode(FIELD_MODE3).description("FieldDescription3").build();

    @Test
    public void testToBuilder() {
        this.compareFieldSchemas(FIELD_SCHEMA1, FIELD_SCHEMA1.toBuilder().build());
        this.compareFieldSchemas(FIELD_SCHEMA2, FIELD_SCHEMA2.toBuilder().build());
        this.compareFieldSchemas(FIELD_SCHEMA3, FIELD_SCHEMA3.toBuilder().build());
        Field field = FIELD_SCHEMA1.toBuilder().description("New Description").build();
        Assert.assertEquals((Object)"New Description", (Object)field.description());
        field = field.toBuilder().description(FIELD_DESCRIPTION1).build();
        this.compareFieldSchemas(FIELD_SCHEMA1, field);
    }

    @Test
    public void testToBuilderIncomplete() {
        Field field = Field.of((String)FIELD_NAME1, (Field.Type)FIELD_TYPE1);
        this.compareFieldSchemas(field, field.toBuilder().build());
        field = Field.of((String)FIELD_NAME2, (Field.Type)FIELD_TYPE3);
        this.compareFieldSchemas(field, field.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)FIELD_NAME1, (Object)FIELD_SCHEMA1.name());
        Assert.assertEquals((Object)FIELD_TYPE1, (Object)FIELD_SCHEMA1.type());
        Assert.assertEquals((Object)FIELD_MODE1, (Object)FIELD_SCHEMA1.mode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION1, (Object)FIELD_SCHEMA1.description());
        Assert.assertEquals(null, (Object)FIELD_SCHEMA1.fields());
        Assert.assertEquals((Object)FIELD_NAME3, (Object)FIELD_SCHEMA3.name());
        Assert.assertEquals((Object)FIELD_TYPE3, (Object)FIELD_SCHEMA3.type());
        Assert.assertEquals((Object)FIELD_MODE3, (Object)FIELD_SCHEMA3.mode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION3, (Object)FIELD_SCHEMA3.description());
        Assert.assertEquals((Object)ImmutableList.of((Object)FIELD_SCHEMA1, (Object)FIELD_SCHEMA2), (Object)FIELD_SCHEMA3.fields());
    }

    @Test
    public void testToAndFromPb() {
        this.compareFieldSchemas(FIELD_SCHEMA1, Field.fromPb((TableFieldSchema)FIELD_SCHEMA1.toPb()));
        this.compareFieldSchemas(FIELD_SCHEMA2, Field.fromPb((TableFieldSchema)FIELD_SCHEMA2.toPb()));
        this.compareFieldSchemas(FIELD_SCHEMA3, Field.fromPb((TableFieldSchema)FIELD_SCHEMA3.toPb()));
        Field field = Field.builder((String)FIELD_NAME1, (Field.Type)FIELD_TYPE1).build();
        this.compareFieldSchemas(field, Field.fromPb((TableFieldSchema)field.toPb()));
    }

    private void compareFieldSchemas(Field expected, Field value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.mode(), (Object)value.mode());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.fields(), (Object)value.fields());
    }
}

