/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableCell;
import com.google.cloud.bigquery.FieldValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueTest {
    private static final TableCell BOOLEAN_FIELD = new TableCell().setV((Object)"false");
    private static final Map<String, String> INTEGER_FIELD = ImmutableMap.of((Object)"v", (Object)"1");
    private static final Map<String, String> FLOAT_FIELD = ImmutableMap.of((Object)"v", (Object)"1.5");
    private static final Map<String, String> STRING_FIELD = ImmutableMap.of((Object)"v", (Object)"string");
    private static final Map<String, String> TIMESTAMP_FIELD = ImmutableMap.of((Object)"v", (Object)"42");
    private static final Map<String, Object> NULL_FIELD = ImmutableMap.of((Object)"v", (Object)Data.nullOf(String.class));
    private static final Map<String, Object> REPEATED_FIELD = ImmutableMap.of((Object)"v", (Object)ImmutableList.of(INTEGER_FIELD, INTEGER_FIELD));
    private static final Map<String, Object> RECORD_FIELD = ImmutableMap.of((Object)"f", (Object)ImmutableList.of(FLOAT_FIELD, TIMESTAMP_FIELD));

    @Test
    public void testFromPb() {
        FieldValue value = FieldValue.fromPb((Object)BOOLEAN_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.attribute());
        Assert.assertFalse((boolean)value.booleanValue());
        value = FieldValue.fromPb(INTEGER_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.attribute());
        Assert.assertEquals((long)1L, (long)value.longValue());
        value = FieldValue.fromPb(FLOAT_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.attribute());
        Assert.assertEquals((double)1.5, (double)value.doubleValue(), (double)0.0);
        value = FieldValue.fromPb(STRING_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.attribute());
        Assert.assertEquals((Object)"string", (Object)value.stringValue());
        value = FieldValue.fromPb(TIMESTAMP_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.attribute());
        Assert.assertEquals((long)42000000L, (long)value.timestampValue());
        value = FieldValue.fromPb(NULL_FIELD);
        Assert.assertNull((Object)value.value());
        value = FieldValue.fromPb(REPEATED_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)value.attribute());
        Assert.assertEquals((Object)FieldValue.fromPb(INTEGER_FIELD), value.repeatedValue().get(0));
        Assert.assertEquals((Object)FieldValue.fromPb(INTEGER_FIELD), value.repeatedValue().get(1));
        value = FieldValue.fromPb(RECORD_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)value.attribute());
        Assert.assertEquals((Object)FieldValue.fromPb(FLOAT_FIELD), value.repeatedValue().get(0));
        Assert.assertEquals((Object)FieldValue.fromPb(TIMESTAMP_FIELD), value.repeatedValue().get(1));
    }

    @Test
    public void testEquals() {
        FieldValue booleanValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"false");
        Assert.assertEquals((Object)booleanValue, (Object)FieldValue.fromPb((Object)BOOLEAN_FIELD));
        Assert.assertEquals((long)booleanValue.hashCode(), (long)FieldValue.fromPb((Object)BOOLEAN_FIELD).hashCode());
        FieldValue integerValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"1");
        Assert.assertEquals((Object)integerValue, (Object)FieldValue.fromPb(INTEGER_FIELD));
        Assert.assertEquals((long)integerValue.hashCode(), (long)FieldValue.fromPb(INTEGER_FIELD).hashCode());
        FieldValue floatValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"1.5");
        Assert.assertEquals((Object)floatValue, (Object)FieldValue.fromPb(FLOAT_FIELD));
        Assert.assertEquals((long)floatValue.hashCode(), (long)FieldValue.fromPb(FLOAT_FIELD).hashCode());
        FieldValue stringValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"string");
        Assert.assertEquals((Object)stringValue, (Object)FieldValue.fromPb(STRING_FIELD));
        Assert.assertEquals((long)stringValue.hashCode(), (long)FieldValue.fromPb(STRING_FIELD).hashCode());
        FieldValue timestampValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"42");
        Assert.assertEquals((Object)timestampValue, (Object)FieldValue.fromPb(TIMESTAMP_FIELD));
        Assert.assertEquals((long)timestampValue.hashCode(), (long)FieldValue.fromPb(TIMESTAMP_FIELD).hashCode());
        FieldValue nullValue = new FieldValue(FieldValue.Attribute.PRIMITIVE, null);
        Assert.assertEquals((Object)nullValue, (Object)FieldValue.fromPb(NULL_FIELD));
        Assert.assertEquals((long)nullValue.hashCode(), (long)FieldValue.fromPb(NULL_FIELD).hashCode());
        FieldValue repeatedValue = new FieldValue(FieldValue.Attribute.REPEATED, (Object)ImmutableList.of((Object)integerValue, (Object)integerValue));
        Assert.assertEquals((Object)repeatedValue, (Object)FieldValue.fromPb(REPEATED_FIELD));
        Assert.assertEquals((long)repeatedValue.hashCode(), (long)FieldValue.fromPb(REPEATED_FIELD).hashCode());
        FieldValue recordValue = new FieldValue(FieldValue.Attribute.RECORD, (Object)ImmutableList.of((Object)floatValue, (Object)timestampValue));
        Assert.assertEquals((Object)recordValue, (Object)FieldValue.fromPb(RECORD_FIELD));
        Assert.assertEquals((long)recordValue.hashCode(), (long)FieldValue.fromPb(RECORD_FIELD).hashCode());
    }
}

