/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class InsertAllRequestTest {
    private static final Map<String, Object> CONTENT1 = ImmutableMap.of((Object)"key", (Object)"val1");
    private static final Map<String, Object> CONTENT2 = ImmutableMap.of((Object)"key", (Object)"val2");
    private static final List<InsertAllRequest.RowToInsert> ROWS = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of(CONTENT1), (Object)InsertAllRequest.RowToInsert.of(CONTENT2));
    private static final List<InsertAllRequest.RowToInsert> ROWS_WITH_ID = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of((String)"id1", CONTENT1), (Object)InsertAllRequest.RowToInsert.of((String)"id2", CONTENT2));
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[0]);
    private static final TableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final boolean SKIP_INVALID_ROWS = true;
    private static final boolean IGNORE_UNKNOWN_VALUES = false;
    private static final String TEMPLATE_SUFFIX = "templateSuffix";
    private static final InsertAllRequest INSERT_ALL_REQUEST1 = InsertAllRequest.builder((TableId)TABLE_ID).addRow(CONTENT1).addRow(CONTENT2).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST2 = InsertAllRequest.builder((TableId)TABLE_ID).rows(ROWS).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST3 = InsertAllRequest.builder((String)TABLE_ID.dataset(), (String)TABLE_ID.table()).rows(ROWS_WITH_ID).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST4 = InsertAllRequest.builder((TableId)TABLE_ID, ROWS).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST5 = InsertAllRequest.builder((String)TABLE_ID.dataset(), (String)TABLE_ID.table(), ROWS_WITH_ID).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST6 = InsertAllRequest.builder((TableId)TABLE_ID, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)}).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST7 = InsertAllRequest.builder((String)TABLE_ID.dataset(), (String)TABLE_ID.table(), (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS_WITH_ID.get(0), ROWS_WITH_ID.get(1)}).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST8 = InsertAllRequest.builder((String)TABLE_ID.dataset(), (String)TABLE_ID.table()).addRow("id1", CONTENT1).addRow("id2", CONTENT2).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST9 = InsertAllRequest.builder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).ignoreUnknownValues(false).skipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST10 = InsertAllRequest.builder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).ignoreUnknownValues(true).skipInvalidRows(false).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST11 = InsertAllRequest.builder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).ignoreUnknownValues(true).skipInvalidRows(false).templateSuffix("templateSuffix").build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST1.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST2.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST3.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST4.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST5.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST6.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST7.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST8.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST9.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST10.table());
        Assert.assertEquals((Object)TABLE_ID, (Object)INSERT_ALL_REQUEST11.table());
        Assert.assertEquals(ROWS, (Object)INSERT_ALL_REQUEST1.rows());
        Assert.assertEquals(ROWS, (Object)INSERT_ALL_REQUEST2.rows());
        Assert.assertEquals(ROWS, (Object)INSERT_ALL_REQUEST4.rows());
        Assert.assertEquals(ROWS, (Object)INSERT_ALL_REQUEST6.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST3.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST5.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST7.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST8.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST9.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST10.rows());
        Assert.assertEquals(ROWS_WITH_ID, (Object)INSERT_ALL_REQUEST11.rows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST1.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST2.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST3.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST4.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST5.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST6.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST7.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST8.skipInvalidRows());
        Assert.assertEquals((Object)true, (Object)INSERT_ALL_REQUEST9.skipInvalidRows());
        Assert.assertFalse((boolean)INSERT_ALL_REQUEST10.skipInvalidRows());
        Assert.assertFalse((boolean)INSERT_ALL_REQUEST11.skipInvalidRows());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST1.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST2.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST3.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST4.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST5.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST6.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST7.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST8.ignoreUnknownValues());
        Assert.assertEquals((Object)false, (Object)INSERT_ALL_REQUEST9.ignoreUnknownValues());
        Assert.assertTrue((boolean)INSERT_ALL_REQUEST10.ignoreUnknownValues());
        Assert.assertTrue((boolean)INSERT_ALL_REQUEST11.ignoreUnknownValues());
        Assert.assertNull((Object)INSERT_ALL_REQUEST1.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST2.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST3.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST4.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST5.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST6.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST7.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST8.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST9.templateSuffix());
        Assert.assertNull((Object)INSERT_ALL_REQUEST10.templateSuffix());
        Assert.assertEquals((Object)TEMPLATE_SUFFIX, (Object)INSERT_ALL_REQUEST11.templateSuffix());
    }

    @Test
    public void testOf() {
        InsertAllRequest request = InsertAllRequest.of((TableId)TABLE_ID, ROWS);
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((TableInfo)TABLE_INFO, ROWS);
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((String)TABLE_ID.dataset(), (String)TABLE_ID.table(), ROWS);
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((String)TABLE_ID.dataset(), (String)TABLE_ID.table(), ROWS);
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((TableId)TABLE_ID, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
        request = InsertAllRequest.of((String)TABLE_ID.dataset(), (String)TABLE_ID.table(), (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Assert.assertEquals((Object)TABLE_ID, (Object)request.table());
        Assert.assertEquals(ROWS, (Object)request.rows());
    }

    @Test
    public void testEquals() {
        this.compareInsertAllRequest(INSERT_ALL_REQUEST1, INSERT_ALL_REQUEST2);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST2, INSERT_ALL_REQUEST4);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST3, INSERT_ALL_REQUEST5);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST4, INSERT_ALL_REQUEST6);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST5, INSERT_ALL_REQUEST7);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST7, INSERT_ALL_REQUEST8);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST8, INSERT_ALL_REQUEST9);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST10, INSERT_ALL_REQUEST10);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST11, INSERT_ALL_REQUEST11);
    }

    private void compareInsertAllRequest(InsertAllRequest expected, InsertAllRequest value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.table(), (Object)value.table());
        Assert.assertEquals((Object)expected.rows(), (Object)value.rows());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.skipInvalidRows(), (Object)value.skipInvalidRows());
        Assert.assertEquals((Object)expected.templateSuffix(), (Object)value.templateSuffix());
    }
}

