/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class InsertAllResponseTest {
    private static final List<BigQueryError> ERRORS1 = ImmutableList.of((Object)new BigQueryError("reason1", "location1", "message1"), (Object)new BigQueryError("reason2", "location2", "message2"));
    private static final List<BigQueryError> ERRORS2 = ImmutableList.of((Object)new BigQueryError("reason3", "location3", "message3"), (Object)new BigQueryError("reason4", "location4", "message4"));
    private static final Map<Long, List<BigQueryError>> ERRORS_MAP = ImmutableMap.of((Object)0L, ERRORS1, (Object)1L, ERRORS2);
    private static final InsertAllResponse INSERT_ALL_RESPONSE = new InsertAllResponse(ERRORS_MAP);
    private static final InsertAllResponse EMPTY_INSERT_ALL_RESPONSE = new InsertAllResponse(null);

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)INSERT_ALL_RESPONSE, (Object)INSERT_ALL_RESPONSE);
    }

    @Test
    public void testErrorsFor() {
        Assert.assertEquals(ERRORS1, (Object)INSERT_ALL_RESPONSE.errorsFor(0L));
        Assert.assertEquals(ERRORS2, (Object)INSERT_ALL_RESPONSE.errorsFor(1L));
        Assert.assertNull((Object)INSERT_ALL_RESPONSE.errorsFor(2L));
    }

    @Test
    public void testHasErrors() {
        Assert.assertTrue((boolean)INSERT_ALL_RESPONSE.hasErrors());
        Assert.assertFalse((boolean)EMPTY_INSERT_ALL_RESPONSE.hasErrors());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareInsertAllResponse(INSERT_ALL_RESPONSE, InsertAllResponse.fromPb((TableDataInsertAllResponse)INSERT_ALL_RESPONSE.toPb()));
        this.compareInsertAllResponse(EMPTY_INSERT_ALL_RESPONSE, InsertAllResponse.fromPb((TableDataInsertAllResponse)EMPTY_INSERT_ALL_RESPONSE.toPb()));
    }

    private void compareInsertAllResponse(InsertAllResponse expected, InsertAllResponse value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.insertErrors(), (Object)value.insertErrors());
    }
}

