/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobReference;
import com.google.cloud.bigquery.JobId;
import org.junit.Assert;
import org.junit.Test;

public class JobIdTest {
    private static final JobId JOB = JobId.of((String)"job");
    private static final JobId JOB_COMPLETE = JobId.of((String)"project", (String)"job");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)JOB.project());
        Assert.assertEquals((Object)"job", (Object)JOB.job());
        Assert.assertEquals((Object)"project", (Object)JOB_COMPLETE.project());
        Assert.assertEquals((Object)"job", (Object)JOB_COMPLETE.job());
    }

    @Test
    public void testEquals() {
        this.compareJobs(JOB, JobId.of((String)"job"));
        this.compareJobs(JOB_COMPLETE, JobId.of((String)"project", (String)"job"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareJobs(JOB, JobId.fromPb((JobReference)JOB.toPb()));
        this.compareJobs(JOB_COMPLETE, JobId.fromPb((JobReference)JOB_COMPLETE.toPb()));
    }

    private void compareJobs(JobId expected, JobId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.project(), (Object)value.project());
        Assert.assertEquals((Object)expected.job(), (Object)value.job());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

