/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JobInfoTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "id";
    private static final String SELF_LINK = "selfLink";
    private static final String EMAIL = "email";
    private static final JobId JOB_ID = JobId.of((String)"job");
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE);
    private static final JobStatistics.CopyStatistics COPY_JOB_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_JOB_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).destinationUriFileCounts((List)ImmutableList.of((Object)42L)).build();
    private static final JobStatistics.LoadStatistics LOAD_JOB_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).inputFiles(Long.valueOf(42L)).outputBytes(Long.valueOf(1024L)).inputBytes(Long.valueOf(2048L)).outputRows(Long.valueOf(24L)).build();
    private static final JobStatistics.QueryStatistics QUERY_JOB_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).totalBytesProcessed(Long.valueOf(2048L)).totalBytesBilled(Long.valueOf(1024L)).cacheHit(Boolean.valueOf(false)).billingTier(Integer.valueOf(42)).build();
    private static final TableId SOURCE_TABLE = TableId.of((String)"dataset", (String)"sourceTable");
    private static final TableId DESTINATION_TABLE = TableId.of((String)"dataset", (String)"destinationTable");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final CopyJobConfiguration COPY_CONFIGURATION = CopyJobConfiguration.builder((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE).createDisposition(CREATE_DISPOSITION).writeDisposition(WRITE_DISPOSITION).build();
    private static final List<String> DESTINATION_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final String FIELD_DELIMITER = ",";
    private static final String FORMAT = "CSV";
    private static final Boolean PRINT_HEADER = true;
    private static final String COMPRESSION = "GZIP";
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION = ExtractJobConfiguration.builder((TableId)TABLE_ID, DESTINATION_URIS).printHeader(PRINT_HEADER).fieldDelimiter(",").compression("GZIP").format("CSV").build();
    private static final List<String> PROJECTION_FIELDS = ImmutableList.of((Object)"field1", (Object)"field2");
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().build();
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).compression("GZIP").ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).build();
    private static final LoadJobConfiguration LOAD_CONFIGURATION = LoadJobConfiguration.builder((TableId)TABLE_ID, SOURCE_URIS).createDisposition(CREATE_DISPOSITION).writeDisposition(WRITE_DISPOSITION).formatOptions((FormatOptions)CSV_OPTIONS).ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).projectionFields(PROJECTION_FIELDS).schema(TABLE_SCHEMA).build();
    private static final String QUERY = "BigQuery SQL";
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean FLATTEN_RESULTS = true;
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final QueryJobConfiguration QUERY_CONFIGURATION = QueryJobConfiguration.builder((String)"BigQuery SQL").useQueryCache(Boolean.valueOf(false)).tableDefinitions(TABLE_DEFINITIONS).allowLargeResults(Boolean.valueOf(true)).createDisposition(CREATE_DISPOSITION).defaultDataset(DATASET_ID).destinationTable(TABLE_ID).writeDisposition(WRITE_DISPOSITION).priority(PRIORITY).flattenResults(Boolean.valueOf(true)).userDefinedFunctions(USER_DEFINED_FUNCTIONS).dryRun(Boolean.valueOf(true)).build();
    private static final JobInfo COPY_JOB = JobInfo.builder((JobConfiguration)COPY_CONFIGURATION).jobId(JOB_ID).statistics((JobStatistics)COPY_JOB_STATISTICS).jobId(JOB_ID).etag("etag").generatedId("id").selfLink("selfLink").userEmail("email").status(JOB_STATUS).build();
    private static final JobInfo EXTRACT_JOB = JobInfo.builder((JobConfiguration)EXTRACT_CONFIGURATION).jobId(JOB_ID).statistics((JobStatistics)EXTRACT_JOB_STATISTICS).jobId(JOB_ID).etag("etag").generatedId("id").selfLink("selfLink").userEmail("email").status(JOB_STATUS).build();
    private static final JobInfo LOAD_JOB = JobInfo.builder((JobConfiguration)LOAD_CONFIGURATION).jobId(JOB_ID).statistics((JobStatistics)LOAD_JOB_STATISTICS).jobId(JOB_ID).etag("etag").generatedId("id").selfLink("selfLink").userEmail("email").status(JOB_STATUS).build();
    private static final JobInfo QUERY_JOB = JobInfo.builder((JobConfiguration)QUERY_CONFIGURATION).jobId(JOB_ID).statistics((JobStatistics)QUERY_JOB_STATISTICS).jobId(JOB_ID).etag("etag").generatedId("id").selfLink("selfLink").userEmail("email").status(JOB_STATUS).build();

    @Test
    public void testToBuilder() {
        this.compareJobInfo(COPY_JOB, COPY_JOB.toBuilder().build());
        this.compareJobInfo(EXTRACT_JOB, EXTRACT_JOB.toBuilder().build());
        this.compareJobInfo(LOAD_JOB, LOAD_JOB.toBuilder().build());
        this.compareJobInfo(QUERY_JOB, QUERY_JOB.toBuilder().build());
        JobInfo job = COPY_JOB.toBuilder().userEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.userEmail());
        job = job.toBuilder().userEmail(EMAIL).build();
        this.compareJobInfo(COPY_JOB, job);
        job = EXTRACT_JOB.toBuilder().userEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.userEmail());
        job = job.toBuilder().userEmail(EMAIL).build();
        this.compareJobInfo(EXTRACT_JOB, job);
        job = LOAD_JOB.toBuilder().userEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.userEmail());
        job = job.toBuilder().userEmail(EMAIL).build();
        this.compareJobInfo(LOAD_JOB, job);
        job = QUERY_JOB.toBuilder().userEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.userEmail());
        job = job.toBuilder().userEmail(EMAIL).build();
        this.compareJobInfo(QUERY_JOB, job);
    }

    @Test
    public void testOf() {
        JobInfo job = JobInfo.of((JobConfiguration)COPY_CONFIGURATION);
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobConfiguration)EXTRACT_CONFIGURATION);
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobConfiguration)LOAD_CONFIGURATION);
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobConfiguration)QUERY_CONFIGURATION);
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)COPY_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.jobId());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)EXTRACT_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.jobId());
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)LOAD_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.jobId());
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)job.configuration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)QUERY_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.jobId());
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)job.configuration());
    }

    @Test
    public void testToBuilderIncomplete() {
        JobInfo job = JobInfo.of((JobConfiguration)COPY_CONFIGURATION);
        this.compareJobInfo(job, job.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ETAG, (Object)COPY_JOB.etag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)COPY_JOB.generatedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)COPY_JOB.selfLink());
        Assert.assertEquals((Object)EMAIL, (Object)COPY_JOB.userEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)COPY_JOB.jobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)COPY_JOB.status());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)COPY_JOB.configuration());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)COPY_JOB.statistics());
        Assert.assertEquals((Object)ETAG, (Object)EXTRACT_JOB.etag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)EXTRACT_JOB.generatedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)EXTRACT_JOB.selfLink());
        Assert.assertEquals((Object)EMAIL, (Object)EXTRACT_JOB.userEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)EXTRACT_JOB.jobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)EXTRACT_JOB.status());
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)EXTRACT_JOB.configuration());
        Assert.assertEquals((Object)EXTRACT_JOB_STATISTICS, (Object)EXTRACT_JOB.statistics());
        Assert.assertEquals((Object)ETAG, (Object)LOAD_JOB.etag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)LOAD_JOB.generatedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)LOAD_JOB.selfLink());
        Assert.assertEquals((Object)EMAIL, (Object)LOAD_JOB.userEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)LOAD_JOB.jobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)LOAD_JOB.status());
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)LOAD_JOB.configuration());
        Assert.assertEquals((Object)LOAD_JOB_STATISTICS, (Object)LOAD_JOB.statistics());
        Assert.assertEquals((Object)ETAG, (Object)QUERY_JOB.etag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)QUERY_JOB.generatedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)QUERY_JOB.selfLink());
        Assert.assertEquals((Object)EMAIL, (Object)QUERY_JOB.userEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)QUERY_JOB.jobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)QUERY_JOB.status());
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)QUERY_JOB.configuration());
        Assert.assertEquals((Object)QUERY_JOB_STATISTICS, (Object)QUERY_JOB.statistics());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)COPY_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)JobStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)COPY_JOB.statistics().toPb()));
        this.compareJobInfo(COPY_JOB, JobInfo.fromPb((Job)COPY_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)COPY_JOB.toPb()).configuration() instanceof CopyJobConfiguration));
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNotNull((Object)EXTRACT_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)EXTRACT_JOB_STATISTICS, (Object)JobStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)EXTRACT_JOB.statistics().toPb()));
        this.compareJobInfo(EXTRACT_JOB, JobInfo.fromPb((Job)EXTRACT_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)EXTRACT_JOB.toPb()).configuration() instanceof ExtractJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)EXTRACT_JOB.toPb()).statistics() instanceof JobStatistics.ExtractStatistics));
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNotNull((Object)LOAD_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)LOAD_JOB_STATISTICS, (Object)JobStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)LOAD_JOB.statistics().toPb()));
        this.compareJobInfo(LOAD_JOB, JobInfo.fromPb((Job)LOAD_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)LOAD_JOB.toPb()).configuration() instanceof LoadJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)LOAD_JOB.toPb()).statistics() instanceof JobStatistics.LoadStatistics));
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNotNull((Object)QUERY_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)QUERY_JOB_STATISTICS, (Object)JobStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)QUERY_JOB.statistics().toPb()));
        this.compareJobInfo(QUERY_JOB, JobInfo.fromPb((Job)QUERY_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)QUERY_JOB.toPb()).configuration() instanceof QueryJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)QUERY_JOB.toPb()).statistics() instanceof JobStatistics.QueryStatistics));
    }

    @Test
    public void testSetProjectId() {
        CopyJobConfiguration copyConfiguration = (CopyJobConfiguration)COPY_JOB.setProjectId("p").configuration();
        Assert.assertEquals((Object)"p", (Object)copyConfiguration.destinationTable().project());
        for (TableId sourceTable : copyConfiguration.sourceTables()) {
            Assert.assertEquals((Object)"p", (Object)sourceTable.project());
        }
        ExtractJobConfiguration extractConfiguration = (ExtractJobConfiguration)EXTRACT_JOB.setProjectId("p").configuration();
        Assert.assertEquals((Object)"p", (Object)extractConfiguration.sourceTable().project());
        LoadJobConfiguration loadConfiguration = (LoadJobConfiguration)LOAD_JOB.setProjectId("p").configuration();
        Assert.assertEquals((Object)"p", (Object)loadConfiguration.destinationTable().project());
        QueryJobConfiguration queryConfiguration = (QueryJobConfiguration)QUERY_JOB.setProjectId("p").configuration();
        Assert.assertEquals((Object)"p", (Object)queryConfiguration.defaultDataset().project());
        Assert.assertEquals((Object)"p", (Object)queryConfiguration.destinationTable().project());
    }

    private void compareJobInfo(JobInfo expected, JobInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.jobId(), (Object)value.jobId());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.statistics(), (Object)value.statistics());
        Assert.assertEquals((Object)expected.userEmail(), (Object)value.userEmail());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
    }
}

