/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryStage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JobStatisticsTest {
    private static final Integer BILLING_TIER = 42;
    private static final Boolean CACHE_HIT = true;
    private static final Long TOTAL_BYTES_BILLED = 24L;
    private static final Long TOTAL_BYTES_PROCESSED = 42L;
    private static final Long INPUT_BYTES = 1L;
    private static final Long INPUT_FILES = 2L;
    private static final Long OUTPUT_BYTES = 3L;
    private static final Long OUTPUT_ROWS = 4L;
    private static final List<Long> FILE_COUNT = ImmutableList.of((Object)1L, (Object)2L, (Object)3L);
    private static final Long CREATION_TIME = 10L;
    private static final Long END_TIME = 20L;
    private static final Long START_TIME = 15L;
    private static final JobStatistics.CopyStatistics COPY_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).destinationUriFileCounts(FILE_COUNT).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).inputBytes(INPUT_BYTES).inputFiles(INPUT_FILES).outputBytes(OUTPUT_BYTES).outputRows(OUTPUT_ROWS).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS_INCOMPLETE = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).inputBytes(INPUT_BYTES).inputFiles(INPUT_FILES).build();
    private static final List<String> SUBSTEPS1 = ImmutableList.of((Object)"substep1", (Object)"substep2");
    private static final List<String> SUBSTEPS2 = ImmutableList.of((Object)"substep3", (Object)"substep4");
    private static final QueryStage.QueryStep QUERY_STEP1 = new QueryStage.QueryStep("KIND", SUBSTEPS1);
    private static final QueryStage.QueryStep QUERY_STEP2 = new QueryStage.QueryStep("KIND", SUBSTEPS2);
    private static final QueryStage QUERY_STAGE = QueryStage.builder().computeRatioAvg(1.1).computeRatioMax(2.2).generatedId(42L).name("stage").readRatioAvg(3.3).readRatioMax(4.4).recordsRead(5L).recordsWritten(6L).steps((List)ImmutableList.of((Object)QUERY_STEP1, (Object)QUERY_STEP2)).waitRatioAvg(7.7).waitRatioMax(8.8).writeRatioAvg(9.9).writeRatioMax(10.1).build();
    private static final List<QueryStage> QUERY_PLAN = ImmutableList.of((Object)QUERY_STAGE);
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).billingTier(BILLING_TIER).cacheHit(CACHE_HIT).totalBytesBilled(TOTAL_BYTES_BILLED).totalBytesProcessed(TOTAL_BYTES_PROCESSED).queryPlan(QUERY_PLAN).build();
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS_INCOMPLETE = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.builder().creationTime(CREATION_TIME)).endTime(END_TIME)).startTime(START_TIME)).billingTier(BILLING_TIER).cacheHit(CACHE_HIT).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)CREATION_TIME, (Object)COPY_STATISTICS.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)COPY_STATISTICS.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)COPY_STATISTICS.endTime());
        Assert.assertEquals((Object)CREATION_TIME, (Object)EXTRACT_STATISTICS.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)EXTRACT_STATISTICS.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)EXTRACT_STATISTICS.endTime());
        Assert.assertEquals(FILE_COUNT, (Object)EXTRACT_STATISTICS.destinationUriFileCounts());
        Assert.assertEquals((Object)CREATION_TIME, (Object)LOAD_STATISTICS.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)LOAD_STATISTICS.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)LOAD_STATISTICS.endTime());
        Assert.assertEquals((Object)INPUT_BYTES, (Object)LOAD_STATISTICS.inputBytes());
        Assert.assertEquals((Object)INPUT_FILES, (Object)LOAD_STATISTICS.inputFiles());
        Assert.assertEquals((Object)OUTPUT_BYTES, (Object)LOAD_STATISTICS.outputBytes());
        Assert.assertEquals((Object)OUTPUT_ROWS, (Object)LOAD_STATISTICS.outputRows());
        Assert.assertEquals((Object)CREATION_TIME, (Object)QUERY_STATISTICS.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)QUERY_STATISTICS.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)QUERY_STATISTICS.endTime());
        Assert.assertEquals((Object)BILLING_TIER, (Object)QUERY_STATISTICS.billingTier());
        Assert.assertEquals((Object)CACHE_HIT, (Object)QUERY_STATISTICS.cacheHit());
        Assert.assertEquals((Object)TOTAL_BYTES_BILLED, (Object)QUERY_STATISTICS.totalBytesBilled());
        Assert.assertEquals((Object)TOTAL_BYTES_PROCESSED, (Object)QUERY_STATISTICS.totalBytesProcessed());
        Assert.assertEquals((Object)TOTAL_BYTES_PROCESSED, (Object)QUERY_STATISTICS.totalBytesProcessed());
        Assert.assertEquals(QUERY_PLAN, (Object)QUERY_STATISTICS.queryPlan());
        Assert.assertEquals((Object)CREATION_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.endTime());
        Assert.assertEquals((Object)INPUT_BYTES, (Object)LOAD_STATISTICS_INCOMPLETE.inputBytes());
        Assert.assertEquals((Object)INPUT_FILES, (Object)LOAD_STATISTICS_INCOMPLETE.inputFiles());
        Assert.assertEquals(null, (Object)LOAD_STATISTICS_INCOMPLETE.outputBytes());
        Assert.assertEquals(null, (Object)LOAD_STATISTICS_INCOMPLETE.outputRows());
        Assert.assertEquals((Object)CREATION_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.creationTime());
        Assert.assertEquals((Object)START_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.endTime());
        Assert.assertEquals((Object)BILLING_TIER, (Object)QUERY_STATISTICS_INCOMPLETE.billingTier());
        Assert.assertEquals((Object)CACHE_HIT, (Object)QUERY_STATISTICS_INCOMPLETE.cacheHit());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.totalBytesBilled());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.totalBytesProcessed());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.queryPlan());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareExtractStatistics(EXTRACT_STATISTICS, JobStatistics.ExtractStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)EXTRACT_STATISTICS.toPb()));
        this.compareLoadStatistics(LOAD_STATISTICS, JobStatistics.LoadStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)LOAD_STATISTICS.toPb()));
        this.compareQueryStatistics(QUERY_STATISTICS, JobStatistics.QueryStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)QUERY_STATISTICS.toPb()));
        this.compareStatistics((JobStatistics)COPY_STATISTICS, JobStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)COPY_STATISTICS.toPb()));
        this.compareLoadStatistics(LOAD_STATISTICS_INCOMPLETE, JobStatistics.LoadStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)LOAD_STATISTICS_INCOMPLETE.toPb()));
        this.compareQueryStatistics(QUERY_STATISTICS_INCOMPLETE, JobStatistics.QueryStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)QUERY_STATISTICS_INCOMPLETE.toPb()));
    }

    private void compareExtractStatistics(JobStatistics.ExtractStatistics expected, JobStatistics.ExtractStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.destinationUriFileCounts(), (Object)value.destinationUriFileCounts());
    }

    private void compareLoadStatistics(JobStatistics.LoadStatistics expected, JobStatistics.LoadStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.inputBytes(), (Object)value.inputBytes());
        Assert.assertEquals((Object)expected.inputFiles(), (Object)value.inputFiles());
        Assert.assertEquals((Object)expected.outputBytes(), (Object)value.outputBytes());
        Assert.assertEquals((Object)expected.outputRows(), (Object)value.outputRows());
    }

    private void compareQueryStatistics(JobStatistics.QueryStatistics expected, JobStatistics.QueryStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.billingTier(), (Object)value.billingTier());
        Assert.assertEquals((Object)expected.cacheHit(), (Object)value.cacheHit());
        Assert.assertEquals((Object)expected.totalBytesBilled(), (Object)value.totalBytesBilled());
        Assert.assertEquals((Object)expected.totalBytesProcessed(), (Object)value.totalBytesProcessed());
        Assert.assertEquals((Object)expected.queryPlan(), (Object)value.queryPlan());
    }

    private void compareStatistics(JobStatistics expected, JobStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.creationTime(), (Object)value.creationTime());
        Assert.assertEquals((Object)expected.endTime(), (Object)value.endTime());
        Assert.assertEquals((Object)expected.startTime(), (Object)value.startTime());
    }
}

