/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.TableId;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JobTest {
    private static final JobId JOB_ID = JobId.of((String)"project", (String)"job");
    private static final TableId TABLE_ID1 = TableId.of((String)"dataset", (String)"table1");
    private static final TableId TABLE_ID2 = TableId.of((String)"dataset", (String)"table2");
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "id";
    private static final String SELF_LINK = "selfLink";
    private static final String EMAIL = "email";
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE);
    private static final JobStatistics COPY_JOB_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).build();
    private static final CopyJobConfiguration COPY_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID1, (TableId)TABLE_ID2);
    private static final JobInfo JOB_INFO = JobInfo.builder((JobConfiguration)COPY_CONFIGURATION).jobId(JOB_ID).statistics(COPY_JOB_STATISTICS).jobId(JOB_ID).etag("etag").generatedId("id").selfLink("selfLink").userEmail("email").status(JOB_STATUS).build();
    private BigQuery serviceMockReturnsOptions = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
    private BigQueryOptions mockOptions = (BigQueryOptions)EasyMock.createMock(BigQueryOptions.class);
    private BigQuery bigquery;
    private Job expectedJob;
    private Job job;

    private void initializeExpectedJob(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.bigquery = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
        this.expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(JOB_INFO));
    }

    private void initializeJob() {
        this.job = new Job(this.bigquery, new JobInfo.BuilderImpl(JOB_INFO));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.bigquery, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedJob(2);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Job builtJob = new Job.Builder(this.serviceMockReturnsOptions, (JobConfiguration)COPY_CONFIGURATION).jobId(JOB_ID).statistics(COPY_JOB_STATISTICS).jobId(JOB_ID).etag(ETAG).generatedId(GENERATED_ID).selfLink(SELF_LINK).userEmail(EMAIL).status(JOB_STATUS).build();
        Assert.assertEquals((Object)ETAG, (Object)builtJob.etag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtJob.generatedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtJob.selfLink());
        Assert.assertEquals((Object)EMAIL, (Object)builtJob.userEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)builtJob.jobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)builtJob.status());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)builtJob.configuration());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)builtJob.statistics());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)builtJob.bigquery());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedJob(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareJob(this.expectedJob, this.expectedJob.toBuilder().build());
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedJob(1);
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId(), expectedOptions)).andReturn((Object)this.expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Assert.assertTrue((boolean)this.job.exists());
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedJob(1);
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Assert.assertFalse((boolean)this.job.exists());
    }

    @Test
    public void testIsDone_True() throws Exception {
        this.initializeExpectedJob(2);
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        JobStatus status = (JobStatus)EasyMock.createStrictMock(JobStatus.class);
        EasyMock.expect((Object)status.state()).andReturn((Object)JobStatus.State.DONE);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId(), expectedOptions)).andReturn((Object)this.expectedJob.toBuilder().status(status).build());
        EasyMock.replay((Object[])new Object[]{status, this.bigquery});
        this.initializeJob();
        Assert.assertTrue((boolean)this.job.isDone());
        EasyMock.verify((Object[])new Object[]{status});
    }

    @Test
    public void testIsDone_False() throws Exception {
        this.initializeExpectedJob(2);
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        JobStatus status = (JobStatus)EasyMock.createStrictMock(JobStatus.class);
        EasyMock.expect((Object)status.state()).andReturn((Object)JobStatus.State.RUNNING);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId(), expectedOptions)).andReturn((Object)this.expectedJob.toBuilder().status(status).build());
        EasyMock.replay((Object[])new Object[]{status, this.bigquery});
        this.initializeJob();
        Assert.assertFalse((boolean)this.job.isDone());
        EasyMock.verify((Object[])new Object[]{status});
    }

    @Test
    public void testIsDone_NotExists() throws Exception {
        this.initializeExpectedJob(1);
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Assert.assertTrue((boolean)this.job.isDone());
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedJob(4);
        JobInfo updatedInfo = JOB_INFO.toBuilder().etag(ETAG).build();
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId().job(), new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Job updatedJob = this.job.reload(new BigQuery.JobOption[0]);
        this.compareJob(expectedJob, updatedJob);
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedJob(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId().job(), new BigQuery.JobOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Assert.assertNull((Object)this.job.reload(new BigQuery.JobOption[0]));
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedJob(4);
        JobInfo updatedInfo = JOB_INFO.toBuilder().etag(ETAG).build();
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getJob(JOB_INFO.jobId().job(), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])})).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Job updatedJob = this.job.reload(new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])});
        this.compareJob(expectedJob, updatedJob);
    }

    @Test
    public void testCancel() throws Exception {
        this.initializeExpectedJob(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.cancel(JOB_INFO.jobId())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeJob();
        Assert.assertTrue((boolean)this.job.cancel());
    }

    @Test
    public void testBigquery() {
        this.initializeExpectedJob(1);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedJob.bigquery());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedJob(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareJob(this.expectedJob, Job.fromPb((BigQuery)this.serviceMockReturnsOptions, (com.google.api.services.bigquery.model.Job)this.expectedJob.toPb()));
    }

    private void compareJob(Job expected, Job value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareJobInfo((JobInfo)expected, (JobInfo)value);
        Assert.assertEquals((Object)expected.bigquery().options(), (Object)value.bigquery().options());
    }

    private void compareJobInfo(JobInfo expected, JobInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.jobId(), (Object)value.jobId());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.statistics(), (Object)value.statistics());
        Assert.assertEquals((Object)expected.userEmail(), (Object)value.userEmail());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
    }
}

