/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LoadJobConfigurationTest {
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().allowJaggedRows(Boolean.valueOf(true)).allowQuotedNewLines(Boolean.valueOf(false)).encoding(StandardCharsets.UTF_8).build();
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final String FORMAT = "CSV";
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final List<String> PROJECTION_FIELDS = ImmutableList.of((Object)"field1", (Object)"field2");
    private static final Field FIELD_SCHEMA = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REQUIRED).description("FieldDescription").build();
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA});
    private static final LoadJobConfiguration LOAD_CONFIGURATION = LoadJobConfiguration.builder((TableId)TABLE_ID, SOURCE_URIS).createDisposition(CREATE_DISPOSITION).writeDisposition(WRITE_DISPOSITION).formatOptions((FormatOptions)CSV_OPTIONS).ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).projectionFields(PROJECTION_FIELDS).schema(TABLE_SCHEMA).build();

    @Test
    public void testToBuilder() {
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION, LOAD_CONFIGURATION.toBuilder().build());
        LoadJobConfiguration configuration = LOAD_CONFIGURATION.toBuilder().destinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configuration.destinationTable().table());
        configuration = configuration.toBuilder().destinationTable(TABLE_ID).build();
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION, configuration);
    }

    @Test
    public void testOf() {
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.destinationTable());
        Assert.assertEquals(SOURCE_URIS, (Object)configuration.sourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS, (FormatOptions)CSV_OPTIONS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.destinationTable());
        Assert.assertEquals((Object)FORMAT, (Object)configuration.format());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)configuration.csvOptions());
        Assert.assertEquals(SOURCE_URIS, (Object)configuration.sourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"uri1");
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.destinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)"uri1"), (Object)configuration.sourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"uri1", (FormatOptions)CSV_OPTIONS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.destinationTable());
        Assert.assertEquals((Object)FORMAT, (Object)configuration.format());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)configuration.csvOptions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"uri1"), (Object)configuration.sourceUris());
    }

    @Test
    public void testToBuilderIncomplete() {
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        this.compareLoadJobConfiguration(configuration, configuration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)LOAD_CONFIGURATION.destinationTable());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)LOAD_CONFIGURATION.createDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)LOAD_CONFIGURATION.writeDisposition());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)LOAD_CONFIGURATION.csvOptions());
        Assert.assertEquals((Object)FORMAT, (Object)LOAD_CONFIGURATION.format());
        Assert.assertEquals((Object)IGNORE_UNKNOWN_VALUES, (Object)LOAD_CONFIGURATION.ignoreUnknownValues());
        Assert.assertEquals((Object)MAX_BAD_RECORDS, (Object)LOAD_CONFIGURATION.maxBadRecords());
        Assert.assertEquals(PROJECTION_FIELDS, (Object)LOAD_CONFIGURATION.projectionFields());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)LOAD_CONFIGURATION.schema());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION, LoadJobConfiguration.fromPb((JobConfiguration)LOAD_CONFIGURATION.toPb()));
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        this.compareLoadJobConfiguration(configuration, LoadJobConfiguration.fromPb((JobConfiguration)configuration.toPb()));
    }

    @Test
    public void testSetProjectId() {
        LoadJobConfiguration configuration = LOAD_CONFIGURATION.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)configuration.destinationTable().project());
    }

    private void compareLoadJobConfiguration(LoadJobConfiguration expected, LoadJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.destinationTable(), (Object)value.destinationTable());
        Assert.assertEquals((Object)expected.createDisposition(), (Object)value.createDisposition());
        Assert.assertEquals((Object)expected.writeDisposition(), (Object)value.writeDisposition());
        Assert.assertEquals((Object)expected.csvOptions(), (Object)value.csvOptions());
        Assert.assertEquals((Object)expected.format(), (Object)value.format());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.maxBadRecords(), (Object)value.maxBadRecords());
        Assert.assertEquals((Object)expected.projectionFields(), (Object)value.projectionFields());
        Assert.assertEquals((Object)expected.schema(), (Object)value.schema());
    }
}

