/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class QueryJobConfigurationTest {
    private static final String QUERY = "BigQuery SQL";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().build();
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).compression("GZIP").ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).build();
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean FLATTEN_RESULTS = true;
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.builder((String)"BigQuery SQL").useQueryCache(Boolean.valueOf(false)).tableDefinitions(TABLE_DEFINITIONS).allowLargeResults(Boolean.valueOf(true)).createDisposition(CREATE_DISPOSITION).defaultDataset(DATASET_ID).destinationTable(TABLE_ID).writeDisposition(WRITE_DISPOSITION).priority(PRIORITY).flattenResults(Boolean.valueOf(true)).userDefinedFunctions(USER_DEFINED_FUNCTIONS).dryRun(Boolean.valueOf(true)).build();

    @Test
    public void testToBuilder() {
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, QUERY_JOB_CONFIGURATION.toBuilder().build());
        QueryJobConfiguration job = QUERY_JOB_CONFIGURATION.toBuilder().query("New BigQuery SQL").build();
        Assert.assertEquals((Object)"New BigQuery SQL", (Object)job.query());
        job = job.toBuilder().query(QUERY).build();
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, job);
    }

    @Test
    public void testOf() {
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        Assert.assertEquals((Object)QUERY, (Object)job.query());
    }

    @Test
    public void testToBuilderIncomplete() {
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        this.compareQueryJobConfiguration(job, job.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)true, (Object)QUERY_JOB_CONFIGURATION.allowLargeResults());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)QUERY_JOB_CONFIGURATION.createDisposition());
        Assert.assertEquals((Object)DATASET_ID, (Object)QUERY_JOB_CONFIGURATION.defaultDataset());
        Assert.assertEquals((Object)TABLE_ID, (Object)QUERY_JOB_CONFIGURATION.destinationTable());
        Assert.assertEquals((Object)true, (Object)QUERY_JOB_CONFIGURATION.flattenResults());
        Assert.assertEquals((Object)PRIORITY, (Object)QUERY_JOB_CONFIGURATION.priority());
        Assert.assertEquals((Object)QUERY, (Object)QUERY_JOB_CONFIGURATION.query());
        Assert.assertEquals(TABLE_DEFINITIONS, (Object)QUERY_JOB_CONFIGURATION.tableDefinitions());
        Assert.assertEquals((Object)false, (Object)QUERY_JOB_CONFIGURATION.useQueryCache());
        Assert.assertEquals(USER_DEFINED_FUNCTIONS, (Object)QUERY_JOB_CONFIGURATION.userDefinedFunctions());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)QUERY_JOB_CONFIGURATION.writeDisposition());
        Assert.assertTrue((boolean)QUERY_JOB_CONFIGURATION.dryRun());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.toPb().getQuery());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getLoad());
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, QueryJobConfiguration.fromPb((JobConfiguration)QUERY_JOB_CONFIGURATION.toPb()));
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        this.compareQueryJobConfiguration(job, QueryJobConfiguration.fromPb((JobConfiguration)job.toPb()));
    }

    @Test
    public void testSetProjectId() {
        QueryJobConfiguration configuration = QUERY_JOB_CONFIGURATION.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)configuration.defaultDataset().project());
        Assert.assertEquals((Object)"p", (Object)configuration.destinationTable().project());
    }

    private void compareQueryJobConfiguration(QueryJobConfiguration expected, QueryJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.dryRun(), (Object)value.dryRun());
        Assert.assertEquals((Object)expected.allowLargeResults(), (Object)value.allowLargeResults());
        Assert.assertEquals((Object)expected.createDisposition(), (Object)value.createDisposition());
        Assert.assertEquals((Object)expected.defaultDataset(), (Object)value.defaultDataset());
        Assert.assertEquals((Object)expected.destinationTable(), (Object)value.destinationTable());
        Assert.assertEquals((Object)expected.flattenResults(), (Object)value.flattenResults());
        Assert.assertEquals((Object)expected.priority(), (Object)value.priority());
        Assert.assertEquals((Object)expected.query(), (Object)value.query());
        Assert.assertEquals((Object)expected.tableDefinitions(), (Object)value.tableDefinitions());
        Assert.assertEquals((Object)expected.useQueryCache(), (Object)value.useQueryCache());
        Assert.assertEquals((Object)expected.userDefinedFunctions(), (Object)value.userDefinedFunctions());
        Assert.assertEquals((Object)expected.writeDisposition(), (Object)value.writeDisposition());
    }
}

