/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.QueryRequest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryRequestTest {
    private static final String QUERY = "BigQuery SQL";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final Boolean USE_QUERY_CACHE = true;
    private static final Boolean DRY_RUN = false;
    private static final Long PAGE_SIZE = 42L;
    private static final Long MAX_WAIT_TIME = 42000L;
    private static final QueryRequest QUERY_REQUEST = QueryRequest.builder((String)"BigQuery SQL").useQueryCache(USE_QUERY_CACHE).defaultDataset(DATASET_ID).dryRun(DRY_RUN).pageSize(PAGE_SIZE).maxWaitTime(MAX_WAIT_TIME).build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testToBuilder() {
        this.compareQueryRequest(QUERY_REQUEST, QUERY_REQUEST.toBuilder().build());
        QueryRequest queryRequest = QUERY_REQUEST.toBuilder().query("New BigQuery SQL").build();
        Assert.assertEquals((Object)"New BigQuery SQL", (Object)queryRequest.query());
        queryRequest = queryRequest.toBuilder().query(QUERY).build();
        this.compareQueryRequest(QUERY_REQUEST, queryRequest);
    }

    @Test
    public void testToBuilderIncomplete() {
        QueryRequest queryRequest = QueryRequest.of((String)QUERY);
        this.compareQueryRequest(queryRequest, queryRequest.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)QUERY, (Object)QUERY_REQUEST.query());
        Assert.assertEquals((Object)USE_QUERY_CACHE, (Object)QUERY_REQUEST.useQueryCache());
        Assert.assertEquals((Object)DATASET_ID, (Object)QUERY_REQUEST.defaultDataset());
        Assert.assertEquals((Object)DRY_RUN, (Object)QUERY_REQUEST.dryRun());
        Assert.assertEquals((Object)PAGE_SIZE, (Object)QUERY_REQUEST.pageSize());
        Assert.assertEquals((Object)MAX_WAIT_TIME, (Object)QUERY_REQUEST.maxWaitTime());
        this.thrown.expect(NullPointerException.class);
        QueryRequest.builder(null);
    }

    @Test
    public void testOf() {
        QueryRequest request = QueryRequest.of((String)QUERY);
        Assert.assertEquals((Object)QUERY, (Object)request.query());
        Assert.assertNull((Object)request.useQueryCache());
        Assert.assertNull((Object)request.defaultDataset());
        Assert.assertNull((Object)request.dryRun());
        Assert.assertNull((Object)request.pageSize());
        Assert.assertNull((Object)request.maxWaitTime());
        this.thrown.expect(NullPointerException.class);
        QueryRequest.of(null);
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareQueryRequest(QUERY_REQUEST, QueryRequest.fromPb((com.google.api.services.bigquery.model.QueryRequest)QUERY_REQUEST.toPb()));
        QueryRequest queryRequest = QueryRequest.of((String)QUERY);
        this.compareQueryRequest(queryRequest, QueryRequest.fromPb((com.google.api.services.bigquery.model.QueryRequest)queryRequest.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)"p", (Object)QUERY_REQUEST.setProjectId("p").defaultDataset().project());
    }

    private void compareQueryRequest(QueryRequest expected, QueryRequest value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.query(), (Object)value.query());
        Assert.assertEquals((Object)expected.useQueryCache(), (Object)value.useQueryCache());
        Assert.assertEquals((Object)expected.defaultDataset(), (Object)value.defaultDataset());
        Assert.assertEquals((Object)expected.dryRun(), (Object)value.dryRun());
        Assert.assertEquals((Object)expected.pageSize(), (Object)value.pageSize());
        Assert.assertEquals((Object)expected.maxWaitTime(), (Object)value.maxWaitTime());
    }
}

