/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.QueryResult;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QueryResponseTest {
    private static final String ETAG = "etag";
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Schema SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1});
    private static final JobId JOB_ID = JobId.of((String)"project", (String)"job");
    private static final Long TOTAL_ROWS = 42L;
    private static final QueryResult.QueryResultsPageFetcher FETCHER = new QueryResult.QueryResultsPageFetcher(){

        public QueryResult nextPage() {
            return null;
        }
    };
    private static final Long TOTAL_BYTES_PROCESSED = 4200L;
    private static final Boolean JOB_COMPLETE = true;
    private static final List<BigQueryError> ERRORS = ImmutableList.of((Object)new BigQueryError("reason1", "location1", "message1", "debugInfo1"), (Object)new BigQueryError("reason2", "location2", "message2", "debugInfo2"));
    private static final Boolean CACHE_HIT = false;
    private static final QueryResult QUERY_RESULT = QueryResult.builder().schema(SCHEMA).totalRows(TOTAL_ROWS.longValue()).totalBytesProcessed(TOTAL_BYTES_PROCESSED.longValue()).cursor("cursor").pageFetcher(FETCHER).results((Iterable)ImmutableList.of()).cacheHit(CACHE_HIT.booleanValue()).build();
    private static final QueryResponse QUERY_RESPONSE = QueryResponse.builder().etag("etag").jobId(JOB_ID).jobCompleted(JOB_COMPLETE.booleanValue()).executionErrors(ERRORS).result(QUERY_RESULT).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ETAG, (Object)QUERY_RESPONSE.etag());
        Assert.assertEquals((Object)QUERY_RESULT, (Object)QUERY_RESPONSE.result());
        Assert.assertEquals((Object)JOB_ID, (Object)QUERY_RESPONSE.jobId());
        Assert.assertEquals((Object)JOB_COMPLETE, (Object)QUERY_RESPONSE.jobCompleted());
        Assert.assertEquals(ERRORS, (Object)QUERY_RESPONSE.executionErrors());
        Assert.assertTrue((boolean)QUERY_RESPONSE.hasErrors());
    }

    @Test
    public void testBuilderIncomplete() {
        QueryResponse queryResponse = QueryResponse.builder().jobCompleted(false).build();
        Assert.assertNull((Object)queryResponse.etag());
        Assert.assertNull((Object)queryResponse.result());
        Assert.assertNull((Object)queryResponse.jobId());
        Assert.assertFalse((boolean)queryResponse.jobCompleted());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)queryResponse.executionErrors());
        Assert.assertFalse((boolean)queryResponse.hasErrors());
    }

    @Test
    public void testEquals() {
        this.compareQueryResponse(QUERY_RESPONSE, QUERY_RESPONSE);
    }

    private void compareQueryResponse(QueryResponse expected, QueryResponse value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.result(), (Object)value.result());
        Assert.assertEquals((Object)expected.jobId(), (Object)value.jobId());
        Assert.assertEquals((Object)expected.jobCompleted(), (Object)value.jobCompleted());
        Assert.assertEquals((Object)expected.executionErrors(), (Object)value.executionErrors());
        Assert.assertEquals((Object)expected.hasErrors(), (Object)value.hasErrors());
    }
}

