/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.QueryResult;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class QueryResultTest {
    private static final String CURSOR = "cursor";
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Schema SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1});
    private static final long TOTAL_ROWS = 42L;
    private static final QueryResult.QueryResultsPageFetcher FETCHER = new QueryResult.QueryResultsPageFetcher(){

        public QueryResult nextPage() {
            return null;
        }
    };
    private static final long TOTAL_BYTES_PROCESSED = 4200L;
    private static final boolean CACHE_HIT = false;
    private static final QueryResult QUERY_RESULT = QueryResult.builder().schema(SCHEMA).totalRows(42L).totalBytesProcessed(4200L).cursor("cursor").pageFetcher(FETCHER).results((Iterable)ImmutableList.of()).cacheHit(false).build();
    private static final QueryResult QUERY_RESULT_INCOMPLETE = QueryResult.builder().totalBytesProcessed(4200L).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)SCHEMA, (Object)QUERY_RESULT.schema());
        Assert.assertEquals((long)42L, (long)QUERY_RESULT.totalRows());
        Assert.assertEquals((long)4200L, (long)QUERY_RESULT.totalBytesProcessed());
        Assert.assertEquals((Object)false, (Object)QUERY_RESULT.cacheHit());
        Assert.assertEquals((Object)CURSOR, (Object)QUERY_RESULT.nextPageCursor());
        Assert.assertEquals(null, (Object)QUERY_RESULT.nextPage());
        Assert.assertEquals(null, (Object)QUERY_RESULT_INCOMPLETE.schema());
        Assert.assertEquals((long)0L, (long)QUERY_RESULT_INCOMPLETE.totalRows());
        Assert.assertEquals((long)4200L, (long)QUERY_RESULT_INCOMPLETE.totalBytesProcessed());
        Assert.assertEquals((Object)false, (Object)QUERY_RESULT_INCOMPLETE.cacheHit());
        Assert.assertEquals(null, (Object)QUERY_RESULT_INCOMPLETE.nextPageCursor());
        Assert.assertEquals(null, (Object)QUERY_RESULT_INCOMPLETE.nextPage());
    }

    @Test
    public void testEquals() {
        this.compareQueryResult(QUERY_RESULT, QUERY_RESULT);
        this.compareQueryResult(QUERY_RESULT_INCOMPLETE, QUERY_RESULT_INCOMPLETE);
    }

    private void compareQueryResult(QueryResult expected, QueryResult value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.nextPage(), (Object)value.nextPage());
        Assert.assertEquals((Object)expected.nextPageCursor(), (Object)value.nextPageCursor());
        Assert.assertEquals((Object)expected.values(), (Object)value.values());
        Assert.assertEquals((Object)expected.schema(), (Object)value.schema());
        Assert.assertEquals((long)expected.totalRows(), (long)value.totalRows());
        Assert.assertEquals((long)expected.totalBytesProcessed(), (long)value.totalBytesProcessed());
        Assert.assertEquals((Object)expected.cacheHit(), (Object)value.cacheHit());
    }
}

