/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ExplainQueryStage;
import com.google.api.services.bigquery.model.ExplainQueryStep;
import com.google.cloud.bigquery.QueryStage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QueryStageTest {
    private static final List<String> SUBSTEPS1 = ImmutableList.of((Object)"substep1", (Object)"substep2");
    private static final List<String> SUBSTEPS2 = ImmutableList.of((Object)"substep3", (Object)"substep4");
    private static final QueryStage.QueryStep QUERY_STEP1 = new QueryStage.QueryStep("KIND", SUBSTEPS1);
    private static final QueryStage.QueryStep QUERY_STEP2 = new QueryStage.QueryStep("KIND", SUBSTEPS2);
    private static final double COMPUTE_RATIO_AVG = 1.1;
    private static final double COMPUTE_RATIO_MAX = 2.2;
    private static final long ID = 42L;
    private static final String NAME = "StageName";
    private static final double READ_RATIO_AVG = 3.3;
    private static final double READ_RATIO_MAX = 4.4;
    private static final long RECORDS_READ = 5L;
    private static final long RECORDS_WRITTEN = 6L;
    private static final List<QueryStage.QueryStep> STEPS = ImmutableList.of((Object)QUERY_STEP1, (Object)QUERY_STEP2);
    private static final double WAIT_RATIO_AVG = 7.7;
    private static final double WAIT_RATIO_MAX = 8.8;
    private static final double WRITE_RATIO_AVG = 9.9;
    private static final double WRITE_RATIO_MAX = 10.1;
    private static final QueryStage QUERY_STAGE = QueryStage.builder().computeRatioAvg(1.1).computeRatioMax(2.2).generatedId(42L).name("StageName").readRatioAvg(3.3).readRatioMax(4.4).recordsRead(5L).recordsWritten(6L).steps(STEPS).waitRatioAvg(7.7).waitRatioMax(8.8).writeRatioAvg(9.9).writeRatioMax(10.1).build();

    @Test
    public void testQueryStepConstructor() {
        Assert.assertEquals((Object)"KIND", (Object)QUERY_STEP1.name());
        Assert.assertEquals((Object)"KIND", (Object)QUERY_STEP2.name());
        Assert.assertEquals(SUBSTEPS1, (Object)QUERY_STEP1.substeps());
        Assert.assertEquals(SUBSTEPS2, (Object)QUERY_STEP2.substeps());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((double)1.1, (double)QUERY_STAGE.computeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)2.2, (double)QUERY_STAGE.computeRatioMax(), (double)0.0);
        Assert.assertEquals((long)42L, (long)QUERY_STAGE.generatedId());
        Assert.assertEquals((Object)NAME, (Object)QUERY_STAGE.name());
        Assert.assertEquals((double)3.3, (double)QUERY_STAGE.readRatioAvg(), (double)0.0);
        Assert.assertEquals((double)4.4, (double)QUERY_STAGE.readRatioMax(), (double)0.0);
        Assert.assertEquals((long)5L, (long)QUERY_STAGE.recordsRead());
        Assert.assertEquals((long)6L, (long)QUERY_STAGE.recordsWritten());
        Assert.assertEquals(STEPS, (Object)QUERY_STAGE.steps());
        Assert.assertEquals((double)7.7, (double)QUERY_STAGE.waitRatioAvg(), (double)0.0);
        Assert.assertEquals((double)8.8, (double)QUERY_STAGE.waitRatioMax(), (double)0.0);
        Assert.assertEquals((double)9.9, (double)QUERY_STAGE.writeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)10.1, (double)QUERY_STAGE.writeRatioMax(), (double)0.0);
    }

    @Test
    public void testToAndFromPb() {
        this.compareQueryStep(QUERY_STEP1, QueryStage.QueryStep.fromPb((ExplainQueryStep)QUERY_STEP1.toPb()));
        this.compareQueryStep(QUERY_STEP2, QueryStage.QueryStep.fromPb((ExplainQueryStep)QUERY_STEP2.toPb()));
        this.compareQueryStage(QUERY_STAGE, QueryStage.fromPb((ExplainQueryStage)QUERY_STAGE.toPb()));
        ExplainQueryStep stepPb = new ExplainQueryStep();
        stepPb.setKind("KIND");
        stepPb.setSubsteps(null);
        this.compareQueryStep(new QueryStage.QueryStep("KIND", (List)ImmutableList.of()), QueryStage.QueryStep.fromPb((ExplainQueryStep)stepPb));
    }

    @Test
    public void testEquals() {
        this.compareQueryStep(QUERY_STEP1, QUERY_STEP1);
        this.compareQueryStep(QUERY_STEP2, QUERY_STEP2);
        this.compareQueryStage(QUERY_STAGE, QUERY_STAGE);
    }

    private void compareQueryStage(QueryStage expected, QueryStage value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((double)expected.computeRatioAvg(), (double)value.computeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.computeRatioMax(), (double)value.computeRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.generatedId(), (long)value.generatedId());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((double)expected.readRatioAvg(), (double)value.readRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.readRatioMax(), (double)value.readRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.recordsRead(), (long)value.recordsRead());
        Assert.assertEquals((long)expected.recordsWritten(), (long)value.recordsWritten());
        Assert.assertEquals((Object)expected.steps(), (Object)value.steps());
        Assert.assertEquals((double)expected.waitRatioAvg(), (double)value.waitRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.waitRatioMax(), (double)value.waitRatioMax(), (double)0.0);
        Assert.assertEquals((double)expected.writeRatioAvg(), (double)value.writeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.writeRatioMax(), (double)value.writeRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }

    private void compareQueryStep(QueryStage.QueryStep expected, QueryStage.QueryStep value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.substeps(), (Object)value.substeps());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

