/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SchemaTest {
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final List<Field> FIELDS = ImmutableList.of((Object)FIELD_SCHEMA1, (Object)FIELD_SCHEMA2, (Object)FIELD_SCHEMA3);
    private static final Schema TABLE_SCHEMA = Schema.builder().fields(FIELDS).build();

    @Test
    public void testToBuilder() {
        this.compareTableSchema(TABLE_SCHEMA, TABLE_SCHEMA.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals(FIELDS, (Object)TABLE_SCHEMA.fields());
        Schema schema = TABLE_SCHEMA.toBuilder().fields(new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).addField(FIELD_SCHEMA3).build();
        this.compareTableSchema(TABLE_SCHEMA, schema);
    }

    @Test
    public void testOf() {
        this.compareTableSchema(TABLE_SCHEMA, Schema.of(FIELDS));
    }

    @Test
    public void testToAndFromPb() {
        this.compareTableSchema(TABLE_SCHEMA, Schema.fromPb((TableSchema)TABLE_SCHEMA.toPb()));
    }

    private void compareTableSchema(Schema expected, Schema value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.fields(), (Object)value.fields());
    }
}

