/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BaseSerializationTest;
import com.google.cloud.Restorable;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.QueryResult;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class SerializationTest
extends BaseSerializationTest {
    private static final Acl DOMAIN_ACCESS = Acl.of((Acl.Entity)new Acl.Domain("domain"), (Acl.Role)Acl.Role.WRITER);
    private static final Acl GROUP_ACCESS = Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER);
    private static final Acl USER_ACCESS = Acl.of((Acl.Entity)new Acl.User("user"), (Acl.Role)Acl.Role.OWNER);
    private static final Acl VIEW_ACCESS = Acl.of((Acl.Entity)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table")), (Acl.Role)Acl.Role.WRITER);
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)DOMAIN_ACCESS, (Object)GROUP_ACCESS, (Object)VIEW_ACCESS, (Object)USER_ACCESS);
    private static final Long CREATION_TIME = System.currentTimeMillis() - 10L;
    private static final Long DEFAULT_TABLE_EXPIRATION = 100L;
    private static final String DESCRIPTION = "Description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"project", (String)"dataset");
    private static final DatasetInfo DATASET_INFO = DatasetInfo.builder((DatasetId)DATASET_ID).acl(ACCESS_RULES).creationTime(CREATION_TIME).defaultTableLifetime(DEFAULT_TABLE_EXPIRATION).description("Description").etag("0xFF00").friendlyName("friendlyDataset").generatedId("P/D:1").lastModified(LAST_MODIFIED).location("").selfLink("http://bigquery/p/d").build();
    private static final TableId TABLE_ID = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().allowJaggedRows(Boolean.valueOf(true)).allowQuotedNewLines(Boolean.valueOf(false)).encoding(StandardCharsets.ISO_8859_1).fieldDelimiter(",").quote("\"").skipLeadingRows(Integer.valueOf(42)).build();
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(1L, 2L, 3L);
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).ignoreUnknownValues(Boolean.valueOf(true)).maxBadRecords(Integer.valueOf(42)).build();
    private static final UserDefinedFunction INLINE_FUNCTION = new UserDefinedFunction.InlineFunction("inline");
    private static final UserDefinedFunction URI_FUNCTION = new UserDefinedFunction.UriFunction("URI");
    private static final TableDefinition TABLE_DEFINITION = ((StandardTableDefinition.Builder)StandardTableDefinition.builder().schema(TABLE_SCHEMA)).location("").streamingBuffer(STREAMING_BUFFER).build();
    private static final TableInfo TABLE_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION).creationTime(CREATION_TIME).description("Description").etag("0xFF00").generatedId("P/D:1").build();
    private static final TableDefinition VIEW_DEFINITION = ViewDefinition.of((String)"QUERY");
    private static final TableInfo VIEW_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)VIEW_DEFINITION).creationTime(CREATION_TIME).description("Description").etag("0xFF00").generatedId("P/D:1").build();
    private static final TableInfo EXTERNAL_TABLE_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION).creationTime(CREATION_TIME).description("Description").etag("0xFF00").generatedId("P/D:1").build();
    private static final JobStatistics.CopyStatistics COPY_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).destinationUriFileCounts((List)ImmutableList.of((Object)42L)).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).inputFiles(Long.valueOf(42L)).outputBytes(Long.valueOf(1024L)).inputBytes(Long.valueOf(2048L)).outputRows(Long.valueOf(24L)).build();
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.builder().creationTime(Long.valueOf(1L))).endTime(Long.valueOf(3L))).startTime(Long.valueOf(2L))).totalBytesProcessed(Long.valueOf(2048L)).totalBytesBilled(Long.valueOf(1024L)).cacheHit(Boolean.valueOf(false)).billingTier(Integer.valueOf(42)).build();
    private static final BigQueryError BIGQUERY_ERROR = new BigQueryError("reason", "location", "message", "debugInfo");
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE, BIGQUERY_ERROR, (List)ImmutableList.of((Object)BIGQUERY_ERROR));
    private static final JobId JOB_ID = JobId.of((String)"project", (String)"job");
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID, (TableId)TABLE_ID);
    private static final ExtractJobConfiguration EXTRACT_JOB_CONFIGURATION = ExtractJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
    private static final WriteChannelConfiguration LOAD_CONFIGURATION = WriteChannelConfiguration.builder((TableId)TABLE_ID).createDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).writeDisposition(JobInfo.WriteDisposition.WRITE_APPEND).formatOptions((FormatOptions)CSV_OPTIONS).ignoreUnknownValues(Boolean.valueOf(true)).maxBadRecords(Integer.valueOf(10)).schema(TABLE_SCHEMA).build();
    private static final LoadJobConfiguration LOAD_JOB_CONFIGURATION = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.of((String)"query");
    private static final JobInfo JOB_INFO = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final Map<String, Object> CONTENT1 = ImmutableMap.of((Object)"key", (Object)"val1");
    private static final Map<String, Object> CONTENT2 = ImmutableMap.of((Object)"key", (Object)"val2");
    private static final InsertAllRequest INSERT_ALL_REQUEST = InsertAllRequest.builder((TableId)TABLE_ID).addRow(CONTENT1).addRow(CONTENT2).ignoreUnknownValues(true).skipInvalidRows(false).build();
    private static final Map<Long, List<BigQueryError>> ERRORS_MAP = ImmutableMap.of((Object)0L, (Object)ImmutableList.of((Object)BIGQUERY_ERROR));
    private static final InsertAllResponse INSERT_ALL_RESPONSE = new InsertAllResponse(ERRORS_MAP);
    private static final FieldValue FIELD_VALUE = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"value");
    private static final QueryRequest QUERY_REQUEST = QueryRequest.builder((String)"query").useQueryCache(Boolean.valueOf(true)).defaultDataset(DATASET_ID).dryRun(Boolean.valueOf(false)).pageSize(Long.valueOf(42L)).maxWaitTime(Long.valueOf(10L)).build();
    private static final QueryResult QUERY_RESULT = QueryResult.builder().schema(TABLE_SCHEMA).totalRows(1L).totalBytesProcessed(42L).cursor("cursor").pageFetcher(null).results((Iterable)ImmutableList.of()).build();
    private static final QueryResponse QUERY_RESPONSE = QueryResponse.builder().etag("0xFF00").jobId(JOB_ID).jobCompleted(true).result(QUERY_RESULT).build();
    private static final BigQuery BIGQUERY = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.builder().projectId("p1")).build().service();
    private static final Dataset DATASET = new Dataset(BIGQUERY, new DatasetInfo.BuilderImpl(DATASET_INFO));
    private static final Table TABLE = new Table(BIGQUERY, new TableInfo.BuilderImpl(TABLE_INFO));
    private static final Job JOB = new Job(BIGQUERY, new JobInfo.BuilderImpl(JOB_INFO));
    private static final BigQueryException BIG_QUERY_EXCEPTION = new BigQueryException(42, "message", BIGQUERY_ERROR);

    protected Serializable[] serializableObjects() {
        BigQueryOptions options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.builder().projectId("p1")).authCredentials(AuthCredentials.createForAppEngine())).build();
        BigQueryOptions otherOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)options.toBuilder().projectId("p2")).authCredentials(null)).build();
        return new Serializable[]{DOMAIN_ACCESS, GROUP_ACCESS, USER_ACCESS, VIEW_ACCESS, DATASET_ID, DATASET_INFO, TABLE_ID, CSV_OPTIONS, STREAMING_BUFFER, TABLE_DEFINITION, EXTERNAL_TABLE_DEFINITION, VIEW_DEFINITION, TABLE_SCHEMA, TABLE_INFO, VIEW_INFO, EXTERNAL_TABLE_INFO, INLINE_FUNCTION, URI_FUNCTION, COPY_STATISTICS, EXTRACT_STATISTICS, LOAD_STATISTICS, QUERY_STATISTICS, BIGQUERY_ERROR, JOB_STATUS, JOB_ID, COPY_JOB_CONFIGURATION, EXTRACT_JOB_CONFIGURATION, LOAD_CONFIGURATION, LOAD_JOB_CONFIGURATION, QUERY_JOB_CONFIGURATION, JOB_INFO, INSERT_ALL_REQUEST, INSERT_ALL_RESPONSE, FIELD_VALUE, QUERY_REQUEST, QUERY_RESPONSE, BIG_QUERY_EXCEPTION, BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0]), BigQuery.DatasetDeleteOption.deleteContents(), BigQuery.DatasetListOption.all(), BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0]), BigQuery.TableListOption.pageSize((long)42L), BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0]), BigQuery.JobListOption.allUsers(), DATASET, TABLE, JOB, options, otherOptions};
    }

    protected Restorable<?>[] restorableObjects() {
        BigQueryOptions options = ((BigQueryOptions.Builder)BigQueryOptions.builder().projectId("p2")).build();
        TableDataWriteChannel writer = new TableDataWriteChannel(options, LOAD_CONFIGURATION, "upload-id");
        return new Restorable[]{writer};
    }
}

