/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.RestorableState;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.spi.ServiceRpcFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableDataWriteChannelTest {
    private static final String UPLOAD_ID = "uploadid";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final WriteChannelConfiguration LOAD_CONFIGURATION = WriteChannelConfiguration.builder((TableId)TABLE_ID).createDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).writeDisposition(JobInfo.WriteDisposition.WRITE_APPEND).formatOptions(FormatOptions.json()).ignoreUnknownValues(Boolean.valueOf(true)).maxBadRecords(Integer.valueOf(10)).build();
    private static final int MIN_CHUNK_SIZE = 262144;
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;
    private static final int CUSTOM_CHUNK_SIZE = 0x100000;
    private static final Random RANDOM = new Random();
    private BigQueryOptions options;
    private BigQueryRpcFactory rpcFactoryMock;
    private BigQueryRpc bigqueryRpcMock;
    private TableDataWriteChannel writer;

    @Before
    public void setUp() {
        this.rpcFactoryMock = (BigQueryRpcFactory)EasyMock.createMock(BigQueryRpcFactory.class);
        this.bigqueryRpcMock = (BigQueryRpc)EasyMock.createMock(BigQueryRpc.class);
        EasyMock.expect((Object)this.rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(BigQueryOptions.class))).andReturn((Object)this.bigqueryRpcMock);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock});
        this.options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.builder().projectId("projectid")).serviceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).build();
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.bigqueryRpcMock});
    }

    @Test
    public void testCreate() {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
    }

    @Test
    public void testWriteWithoutFlush() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        Assert.assertEquals((long)262144L, (long)this.writer.write(ByteBuffer.allocate(262144)));
    }

    @Test
    public void testWriteWithFlush() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)0x100000), EasyMock.eq((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        this.writer.chunkSize(0x100000);
        ByteBuffer buffer = TableDataWriteChannelTest.randomBuffer(0x100000);
        Assert.assertEquals((long)0x100000L, (long)this.writer.write(buffer));
        Assert.assertArrayEquals((byte[])buffer.array(), (byte[])((byte[])capturedBuffer.getValue()));
    }

    @Test
    public void testWritesAndFlush() throws IOException {
        int i;
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)0x200000), EasyMock.eq((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        ByteBuffer[] buffers = new ByteBuffer[8];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = TableDataWriteChannelTest.randomBuffer(262144);
            Assert.assertEquals((long)262144L, (long)this.writer.write(buffers[i]));
        }
        for (i = 0; i < buffers.length; ++i) {
            Assert.assertArrayEquals((byte[])buffers[i].array(), (byte[])Arrays.copyOfRange((byte[])capturedBuffer.getValue(), 262144 * i, 262144 * (i + 1)));
        }
    }

    @Test
    public void testCloseWithoutFlush() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        this.writer.close();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])capturedBuffer.getValue()));
        Assert.assertTrue((!this.writer.isOpen() ? 1 : 0) != 0);
    }

    @Test
    public void testCloseWithFlush() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        ByteBuffer buffer = TableDataWriteChannelTest.randomBuffer(262144);
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)262144), EasyMock.eq((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        this.writer.write(buffer);
        this.writer.close();
        Assert.assertEquals((long)0x200000L, (long)((byte[])capturedBuffer.getValue()).length);
        Assert.assertArrayEquals((byte[])buffer.array(), (byte[])Arrays.copyOf((byte[])capturedBuffer.getValue(), 262144));
        Assert.assertTrue((!this.writer.isOpen() ? 1 : 0) != 0);
    }

    @Test
    public void testWriteClosed() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        this.writer.close();
        try {
            this.writer.write(ByteBuffer.allocate(262144));
            Assert.fail((String)"Expected TableDataWriteChannel write to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSaveAndRestore() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance((CaptureType)CaptureType.ALL);
        Capture capturedPosition = Capture.newInstance((CaptureType)CaptureType.ALL);
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.captureLong((Capture)capturedPosition), EasyMock.eq((int)0x200000), EasyMock.eq((boolean)false));
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        ByteBuffer buffer1 = TableDataWriteChannelTest.randomBuffer(0x200000);
        ByteBuffer buffer2 = TableDataWriteChannelTest.randomBuffer(0x200000);
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        Assert.assertEquals((long)0x200000L, (long)this.writer.write(buffer1));
        Assert.assertArrayEquals((byte[])buffer1.array(), (byte[])((byte[])capturedBuffer.getValues().get(0)));
        Assert.assertEquals((Object)new Long(0L), capturedPosition.getValues().get(0));
        RestorableState writerState = this.writer.capture();
        WriteChannel restoredWriter = (WriteChannel)writerState.restore();
        Assert.assertEquals((long)0x200000L, (long)restoredWriter.write(buffer2));
        Assert.assertArrayEquals((byte[])buffer2.array(), (byte[])((byte[])capturedBuffer.getValues().get(1)));
        Assert.assertEquals((Object)new Long(0x200000L), capturedPosition.getValues().get(1));
    }

    @Test
    public void testSaveAndRestoreClosed() throws IOException {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID);
        Capture capturedBuffer = Capture.newInstance();
        this.bigqueryRpcMock.write((String)EasyMock.eq((Object)UPLOAD_ID), (byte[])EasyMock.capture((Capture)capturedBuffer), EasyMock.eq((int)0), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        this.writer.close();
        RestorableState writerState = this.writer.capture();
        RestorableState expectedWriterState = TableDataWriteChannel.StateImpl.builder((BigQueryOptions)this.options, (WriteChannelConfiguration)LOAD_CONFIGURATION, (String)UPLOAD_ID).buffer(null).chunkSize(0x200000).isOpen(false).position(0).build();
        WriteChannel restoredWriter = (WriteChannel)writerState.restore();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])capturedBuffer.getValue()));
        Assert.assertEquals((Object)expectedWriterState, (Object)restoredWriter.capture());
    }

    @Test
    public void testStateEquals() {
        EasyMock.expect((Object)this.bigqueryRpcMock.open(LOAD_CONFIGURATION.toPb())).andReturn((Object)UPLOAD_ID).times(2);
        EasyMock.replay((Object[])new Object[]{this.bigqueryRpcMock});
        this.writer = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        TableDataWriteChannel writer2 = new TableDataWriteChannel(this.options, LOAD_CONFIGURATION);
        RestorableState state = this.writer.capture();
        RestorableState state2 = writer2.capture();
        Assert.assertEquals((Object)state, (Object)state2);
        Assert.assertEquals((long)state.hashCode(), (long)state2.hashCode());
        Assert.assertEquals((Object)state.toString(), (Object)state2.toString());
    }

    private static ByteBuffer randomBuffer(int size) {
        byte[] byteArray = new byte[size];
        RANDOM.nextBytes(byteArray);
        return ByteBuffer.wrap(byteArray);
    }
}

