/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import org.junit.Assert;
import org.junit.Test;

public class TableDefinitionTest {
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Long NUM_BYTES = 42L;
    private static final Long NUM_ROWS = 43L;
    private static final String LOCATION = "US";
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(1L, 2L, 3L);
    private static final StandardTableDefinition TABLE_DEFINITION = ((StandardTableDefinition.Builder)StandardTableDefinition.builder().location("US").numBytes(NUM_BYTES).numRows(NUM_ROWS).streamingBuffer(STREAMING_BUFFER).schema(TABLE_SCHEMA)).build();

    @Test
    public void testToBuilder() {
        this.compareTableDefinition(TABLE_DEFINITION, TABLE_DEFINITION.toBuilder().build());
        StandardTableDefinition tableDefinition = TABLE_DEFINITION.toBuilder().location("EU").build();
        Assert.assertEquals((Object)"EU", (Object)tableDefinition.location());
        tableDefinition = tableDefinition.toBuilder().location(LOCATION).build();
        this.compareTableDefinition(TABLE_DEFINITION, tableDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Assert.assertEquals((Object)tableDefinition, (Object)tableDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)TABLE_DEFINITION.type());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)TABLE_DEFINITION.schema());
        Assert.assertEquals((Object)LOCATION, (Object)TABLE_DEFINITION.location());
        Assert.assertEquals((Object)NUM_BYTES, (Object)TABLE_DEFINITION.numBytes());
        Assert.assertEquals((Object)NUM_ROWS, (Object)TABLE_DEFINITION.numRows());
        Assert.assertEquals((Object)STREAMING_BUFFER, (Object)TABLE_DEFINITION.streamingBuffer());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)TABLE_DEFINITION.toPb()) instanceof StandardTableDefinition));
        this.compareTableDefinition(TABLE_DEFINITION, (StandardTableDefinition)TableDefinition.fromPb((Table)TABLE_DEFINITION.toPb()));
    }

    private void compareTableDefinition(StandardTableDefinition expected, StandardTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.schema(), (Object)value.schema());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.numBytes(), (Object)value.numBytes());
        Assert.assertEquals((Object)expected.numRows(), (Object)value.numRows());
        Assert.assertEquals((Object)expected.location(), (Object)value.location());
        Assert.assertEquals((Object)expected.streamingBuffer(), (Object)value.streamingBuffer());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

