/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.TableId;
import org.junit.Assert;
import org.junit.Test;

public class TableIdTest {
    private static final TableId TABLE = TableId.of((String)"dataset", (String)"table");
    private static final TableId TABLE_COMPLETE = TableId.of((String)"project", (String)"dataset", (String)"table");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)TABLE.project());
        Assert.assertEquals((Object)"dataset", (Object)TABLE.dataset());
        Assert.assertEquals((Object)"table", (Object)TABLE.table());
        Assert.assertEquals((Object)"project", (Object)TABLE_COMPLETE.project());
        Assert.assertEquals((Object)"dataset", (Object)TABLE_COMPLETE.dataset());
        Assert.assertEquals((Object)"table", (Object)TABLE_COMPLETE.table());
    }

    @Test
    public void testEquals() {
        this.compareTableIds(TABLE, TableId.of((String)"dataset", (String)"table"));
        this.compareTableIds(TABLE_COMPLETE, TableId.of((String)"project", (String)"dataset", (String)"table"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareTableIds(TABLE, TableId.fromPb((TableReference)TABLE.toPb()));
        this.compareTableIds(TABLE_COMPLETE, TableId.fromPb((TableReference)TABLE_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)TABLE_COMPLETE, (Object)TABLE.setProjectId("project"));
    }

    private void compareTableIds(TableId expected, TableId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)value.project());
        Assert.assertEquals((Object)expected.dataset(), (Object)value.dataset());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

