/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TableInfoTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "project:dataset:table";
    private static final String SELF_LINK = "selfLink";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String DESCRIPTION = "description";
    private static final Long CREATION_TIME = 10L;
    private static final Long EXPIRATION_TIME = 100L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final Field FIELD_SCHEMA1 = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2})).mode(Field.Mode.REQUIRED).description("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Long NUM_BYTES = 42L;
    private static final Long NUM_ROWS = 43L;
    private static final String LOCATION = "US";
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(1L, 2L, 3L);
    private static final StandardTableDefinition TABLE_DEFINITION = ((StandardTableDefinition.Builder)StandardTableDefinition.builder().location("US").numBytes(NUM_BYTES).numRows(NUM_ROWS).streamingBuffer(STREAMING_BUFFER).schema(TABLE_SCHEMA)).build();
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.builder().build();
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.builder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).compression("GZIP").ignoreUnknownValues(IGNORE_UNKNOWN_VALUES).maxBadRecords(MAX_BAD_RECORDS).build();
    private static final String VIEW_QUERY = "VIEW QUERY";
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final ViewDefinition VIEW_TYPE = ViewDefinition.builder((String)"VIEW QUERY", USER_DEFINED_FUNCTIONS).build();
    private static final TableInfo TABLE_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION).creationTime(CREATION_TIME).description("description").etag("etag").expirationTime(EXPIRATION_TIME).friendlyName("friendlyName").generatedId("project:dataset:table").lastModifiedTime(LAST_MODIFIED_TIME).selfLink("selfLink").build();
    private static final TableInfo VIEW_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)VIEW_TYPE).creationTime(CREATION_TIME).description("description").etag("etag").expirationTime(EXPIRATION_TIME).friendlyName("friendlyName").generatedId("project:dataset:table").lastModifiedTime(LAST_MODIFIED_TIME).selfLink("selfLink").build();
    private static final TableInfo EXTERNAL_TABLE_INFO = TableInfo.builder((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION).creationTime(CREATION_TIME).description("description").etag("etag").expirationTime(EXPIRATION_TIME).friendlyName("friendlyName").generatedId("project:dataset:table").lastModifiedTime(LAST_MODIFIED_TIME).selfLink("selfLink").build();

    @Test
    public void testToBuilder() {
        this.compareTableInfo(TABLE_INFO, TABLE_INFO.toBuilder().build());
        this.compareTableInfo(VIEW_INFO, VIEW_INFO.toBuilder().build());
        this.compareTableInfo(EXTERNAL_TABLE_INFO, EXTERNAL_TABLE_INFO.toBuilder().build());
        TableInfo tableInfo = TABLE_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)tableInfo.description());
        tableInfo = tableInfo.toBuilder().description(DESCRIPTION).build();
        this.compareTableInfo(TABLE_INFO, tableInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        TableInfo tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)VIEW_TYPE);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)TABLE_INFO.tableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)TABLE_INFO.creationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)TABLE_INFO.description());
        Assert.assertEquals((Object)ETAG, (Object)TABLE_INFO.etag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)TABLE_INFO.expirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)TABLE_INFO.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)TABLE_INFO.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)TABLE_INFO.lastModifiedTime());
        Assert.assertEquals((Object)TABLE_DEFINITION, (Object)TABLE_INFO.definition());
        Assert.assertEquals((Object)SELF_LINK, (Object)TABLE_INFO.selfLink());
        Assert.assertEquals((Object)TABLE_ID, (Object)VIEW_INFO.tableId());
        Assert.assertEquals((Object)VIEW_TYPE, (Object)VIEW_INFO.definition());
        Assert.assertEquals((Object)CREATION_TIME, (Object)VIEW_INFO.creationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)VIEW_INFO.description());
        Assert.assertEquals((Object)ETAG, (Object)VIEW_INFO.etag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)VIEW_INFO.expirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)VIEW_INFO.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)VIEW_INFO.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)VIEW_INFO.lastModifiedTime());
        Assert.assertEquals((Object)VIEW_TYPE, (Object)VIEW_INFO.definition());
        Assert.assertEquals((Object)SELF_LINK, (Object)VIEW_INFO.selfLink());
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTERNAL_TABLE_INFO.tableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)EXTERNAL_TABLE_INFO.creationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)EXTERNAL_TABLE_INFO.description());
        Assert.assertEquals((Object)ETAG, (Object)EXTERNAL_TABLE_INFO.etag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)EXTERNAL_TABLE_INFO.expirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)EXTERNAL_TABLE_INFO.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)EXTERNAL_TABLE_INFO.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)EXTERNAL_TABLE_INFO.lastModifiedTime());
        Assert.assertEquals((Object)EXTERNAL_TABLE_DEFINITION, (Object)EXTERNAL_TABLE_INFO.definition());
        Assert.assertEquals((Object)SELF_LINK, (Object)EXTERNAL_TABLE_INFO.selfLink());
    }

    @Test
    public void testToAndFromPb() {
        this.compareTableInfo(TABLE_INFO, TableInfo.fromPb((Table)TABLE_INFO.toPb()));
        this.compareTableInfo(VIEW_INFO, TableInfo.fromPb((Table)VIEW_INFO.toPb()));
        this.compareTableInfo(EXTERNAL_TABLE_INFO, TableInfo.fromPb((Table)EXTERNAL_TABLE_INFO.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)"project", (Object)TABLE_INFO.setProjectId("project").tableId().project());
        Assert.assertEquals((Object)"project", (Object)EXTERNAL_TABLE_INFO.setProjectId("project").tableId().project());
        Assert.assertEquals((Object)"project", (Object)VIEW_INFO.setProjectId("project").tableId().project());
    }

    private void compareTableInfo(TableInfo expected, TableInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.tableId(), (Object)value.tableId());
        Assert.assertEquals((Object)expected.definition(), (Object)value.definition());
        Assert.assertEquals((Object)expected.creationTime(), (Object)value.creationTime());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.expirationTime(), (Object)value.expirationTime());
        Assert.assertEquals((Object)expected.friendlyName(), (Object)value.friendlyName());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.lastModifiedTime(), (Object)value.lastModifiedTime());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.definition(), (Object)value.definition());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

