/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TableTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "project:dataset:table1";
    private static final String SELF_LINK = "selfLink";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String DESCRIPTION = "description";
    private static final Long CREATION_TIME = 10L;
    private static final Long EXPIRATION_TIME = 100L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final TableId TABLE_ID1 = TableId.of((String)"dataset", (String)"table1");
    private static final TableId TABLE_ID2 = TableId.of((String)"dataset", (String)"table2");
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID2, (TableId)TABLE_ID1);
    private static final JobInfo COPY_JOB_INFO = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final JobInfo LOAD_JOB_INFO = JobInfo.of((JobConfiguration)LoadJobConfiguration.of((TableId)TABLE_ID1, (List)ImmutableList.of((Object)"URI"), (FormatOptions)FormatOptions.json()));
    private static final JobInfo EXTRACT_JOB_INFO = JobInfo.of((JobConfiguration)ExtractJobConfiguration.of((TableId)TABLE_ID1, (List)ImmutableList.of((Object)"URI"), (String)"CSV"));
    private static final Field FIELD = Field.of((String)"FieldName", (Field.Type)Field.Type.integer());
    private static final TableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{FIELD}));
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID1, (TableDefinition)TABLE_DEFINITION);
    private static final List<InsertAllRequest.RowToInsert> ROWS_TO_INSERT = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of((String)"id1", (Map)ImmutableMap.of((Object)"key", (Object)"val1")), (Object)InsertAllRequest.RowToInsert.of((String)"id2", (Map)ImmutableMap.of((Object)"key", (Object)"val2")));
    private static final InsertAllRequest INSERT_ALL_REQUEST = InsertAllRequest.of((TableId)TABLE_ID1, ROWS_TO_INSERT);
    private static final InsertAllRequest INSERT_ALL_REQUEST_COMPLETE = InsertAllRequest.builder((TableId)TABLE_ID1, ROWS_TO_INSERT).skipInvalidRows(true).ignoreUnknownValues(true).build();
    private static final InsertAllResponse EMPTY_INSERT_ALL_RESPONSE = new InsertAllResponse((Map)ImmutableMap.of());
    private static final FieldValue FIELD_VALUE1 = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"val1");
    private static final FieldValue FIELD_VALUE2 = new FieldValue(FieldValue.Attribute.PRIMITIVE, (Object)"val1");
    private static final Iterable<List<FieldValue>> ROWS = ImmutableList.of((Object)ImmutableList.of((Object)FIELD_VALUE1), (Object)ImmutableList.of((Object)FIELD_VALUE2));
    private BigQuery serviceMockReturnsOptions = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
    private BigQueryOptions mockOptions = (BigQueryOptions)EasyMock.createMock(BigQueryOptions.class);
    private BigQuery bigquery;
    private Table expectedTable;
    private Table table;

    private void initializeExpectedTable(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.bigquery = (BigQuery)EasyMock.createStrictMock(BigQuery.class);
        this.expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(TABLE_INFO));
    }

    private void initializeTable() {
        this.table = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.bigquery, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedTable(2);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Table builtTable = new Table.Builder(this.serviceMockReturnsOptions, TABLE_ID1, TABLE_DEFINITION).creationTime(CREATION_TIME).description(DESCRIPTION).etag(ETAG).expirationTime(EXPIRATION_TIME).friendlyName(FRIENDLY_NAME).generatedId(GENERATED_ID).lastModifiedTime(LAST_MODIFIED_TIME).selfLink(SELF_LINK).build();
        Assert.assertEquals((Object)TABLE_ID1, (Object)builtTable.tableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)builtTable.creationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)builtTable.description());
        Assert.assertEquals((Object)ETAG, (Object)builtTable.etag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)builtTable.expirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)builtTable.friendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtTable.generatedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)builtTable.lastModifiedTime());
        Assert.assertEquals((Object)TABLE_DEFINITION, (Object)builtTable.definition());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtTable.selfLink());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)builtTable.bigquery());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedTable(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareTable(this.expectedTable, this.expectedTable.toBuilder().build());
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedTable(1);
        BigQuery.TableOption[] expectedOptions = new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO.tableId(), expectedOptions)).andReturn((Object)this.expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Assert.assertTrue((boolean)this.table.exists());
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedTable(1);
        BigQuery.TableOption[] expectedOptions = new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])};
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO.tableId(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Assert.assertFalse((boolean)this.table.exists());
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedTable(4);
        TableInfo updatedInfo = TABLE_INFO.toBuilder().description("Description").build();
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO.tableId(), new BigQuery.TableOption[0])).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Table updatedTable = this.table.reload(new BigQuery.TableOption[0]);
        this.compareTable(expectedTable, updatedTable);
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO.tableId(), new BigQuery.TableOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Assert.assertNull((Object)this.table.reload(new BigQuery.TableOption[0]));
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedTable(4);
        TableInfo updatedInfo = TABLE_INFO.toBuilder().description("Description").build();
        Table expectedTable = new Table(this.serviceMockReturnsOptions, new TableInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.getTable(TABLE_INFO.tableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).andReturn((Object)expectedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Table updatedTable = this.table.reload(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        this.compareTable(expectedTable, updatedTable);
    }

    @Test
    public void testUpdate() {
        this.initializeExpectedTable(4);
        Table expectedUpdatedTable = this.expectedTable.toBuilder().description("Description").build();
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.update((TableInfo)EasyMock.eq((Object)this.expectedTable), new BigQuery.TableOption[0])).andReturn((Object)expectedUpdatedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Table actualUpdatedTable = this.table.update(new BigQuery.TableOption[0]);
        this.compareTable(expectedUpdatedTable, actualUpdatedTable);
    }

    @Test
    public void testUpdateWithOptions() {
        this.initializeExpectedTable(4);
        Table expectedUpdatedTable = this.expectedTable.toBuilder().description("Description").build();
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.update((TableInfo)EasyMock.eq((Object)this.expectedTable), new BigQuery.TableOption[]{(BigQuery.TableOption)EasyMock.eq((Object)BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0]))})).andReturn((Object)expectedUpdatedTable);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Table actualUpdatedTable = this.table.update(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        this.compareTable(expectedUpdatedTable, actualUpdatedTable);
    }

    @Test
    public void testDeleteTrue() {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.delete(TABLE_INFO.tableId())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Assert.assertTrue((boolean)this.table.delete());
    }

    @Test
    public void testDeleteFalse() {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.delete(TABLE_INFO.tableId())).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Assert.assertFalse((boolean)this.table.delete());
    }

    @Test
    public void testInsert() throws Exception {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.insertAll(INSERT_ALL_REQUEST)).andReturn((Object)EMPTY_INSERT_ALL_RESPONSE);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        InsertAllResponse response = this.table.insert(ROWS_TO_INSERT);
        Assert.assertSame((Object)EMPTY_INSERT_ALL_RESPONSE, (Object)response);
    }

    @Test
    public void testInsertComplete() throws Exception {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.bigquery.insertAll(INSERT_ALL_REQUEST_COMPLETE)).andReturn((Object)EMPTY_INSERT_ALL_RESPONSE);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        InsertAllResponse response = this.table.insert(ROWS_TO_INSERT, true, true);
        Assert.assertSame((Object)EMPTY_INSERT_ALL_RESPONSE, (Object)response);
    }

    @Test
    public void testList() throws Exception {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        PageImpl tableDataPage = new PageImpl(null, "c", ROWS);
        EasyMock.expect((Object)this.bigquery.listTableData(TABLE_ID1, new BigQuery.TableDataListOption[0])).andReturn((Object)tableDataPage);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Page dataPage = this.table.list(new BigQuery.TableDataListOption[0]);
        Iterator tableDataIterator = tableDataPage.values().iterator();
        Iterator dataIterator = dataPage.values().iterator();
        Assert.assertTrue((boolean)Iterators.elementsEqual(tableDataIterator, dataIterator));
    }

    @Test
    public void testListWithOptions() throws Exception {
        this.initializeExpectedTable(1);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        PageImpl tableDataPage = new PageImpl(null, "c", ROWS);
        EasyMock.expect((Object)this.bigquery.listTableData(TABLE_ID1, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)})).andReturn((Object)tableDataPage);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Page dataPage = this.table.list(new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)});
        Iterator tableDataIterator = tableDataPage.values().iterator();
        Iterator dataIterator = dataPage.values().iterator();
        Assert.assertTrue((boolean)Iterators.elementsEqual(tableDataIterator, dataIterator));
    }

    @Test
    public void testCopyFromString() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(COPY_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(COPY_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.copy(TABLE_ID2.dataset(), TABLE_ID2.table(), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testCopyFromId() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(COPY_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(COPY_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.copy(TABLE_ID2.dataset(), TABLE_ID2.table(), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testLoadDataUri() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(LOAD_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(LOAD_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.load(FormatOptions.json(), "URI", new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testLoadDataUris() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(LOAD_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(LOAD_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.load(FormatOptions.json(), (List)ImmutableList.of((Object)"URI"), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testExtractDataUri() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(EXTRACT_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.extract("CSV", "URI", new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testExtractDataUris() throws Exception {
        this.initializeExpectedTable(2);
        EasyMock.expect((Object)this.bigquery.options()).andReturn((Object)this.mockOptions);
        Job expectedJob = new Job(this.serviceMockReturnsOptions, new JobInfo.BuilderImpl(EXTRACT_JOB_INFO));
        EasyMock.expect((Object)this.bigquery.create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0])).andReturn((Object)expectedJob);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.initializeTable();
        Job job = this.table.extract("CSV", (List)ImmutableList.of((Object)"URI"), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
    }

    @Test
    public void testBigquery() {
        this.initializeExpectedTable(1);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedTable.bigquery());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedTable(4);
        EasyMock.replay((Object[])new Object[]{this.bigquery});
        this.compareTable(this.expectedTable, Table.fromPb((BigQuery)this.serviceMockReturnsOptions, (com.google.api.services.bigquery.model.Table)this.expectedTable.toPb()));
    }

    private void compareTable(Table expected, Table value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareTableInfo((TableInfo)expected, (TableInfo)value);
        Assert.assertEquals((Object)expected.bigquery().options(), (Object)value.bigquery().options());
    }

    private void compareTableInfo(TableInfo expected, TableInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.tableId(), (Object)value.tableId());
        Assert.assertEquals((Object)expected.definition(), (Object)value.definition());
        Assert.assertEquals((Object)expected.creationTime(), (Object)value.creationTime());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.etag(), (Object)value.etag());
        Assert.assertEquals((Object)expected.expirationTime(), (Object)value.expirationTime());
        Assert.assertEquals((Object)expected.friendlyName(), (Object)value.friendlyName());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.lastModifiedTime(), (Object)value.lastModifiedTime());
        Assert.assertEquals((Object)expected.selfLink(), (Object)value.selfLink());
        Assert.assertEquals((Object)expected.definition(), (Object)value.definition());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

