/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.UserDefinedFunctionResource;
import com.google.cloud.bigquery.UserDefinedFunction;
import org.junit.Assert;
import org.junit.Test;

public class UserDefinedFunctionTest {
    private static final String INLINE = "inline";
    private static final String URI = "uri";
    private static final UserDefinedFunction INLINE_FUNCTION = new UserDefinedFunction.InlineFunction("inline");
    private static final UserDefinedFunction URI_FUNCTION = new UserDefinedFunction.UriFunction("uri");

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)INLINE, (Object)INLINE_FUNCTION.content());
        Assert.assertEquals((Object)UserDefinedFunction.Type.INLINE, (Object)INLINE_FUNCTION.type());
        Assert.assertEquals((Object)URI, (Object)URI_FUNCTION.content());
        Assert.assertEquals((Object)UserDefinedFunction.Type.FROM_URI, (Object)URI_FUNCTION.type());
    }

    @Test
    public void testFactoryMethod() {
        this.compareUserDefinedFunction(INLINE_FUNCTION, UserDefinedFunction.inline((String)INLINE));
        this.compareUserDefinedFunction(URI_FUNCTION, UserDefinedFunction.fromUri((String)URI));
    }

    @Test
    public void testToAndFromPb() {
        this.compareUserDefinedFunction(INLINE_FUNCTION, UserDefinedFunction.fromPb((UserDefinedFunctionResource)INLINE_FUNCTION.toPb()));
        this.compareUserDefinedFunction(URI_FUNCTION, UserDefinedFunction.fromPb((UserDefinedFunctionResource)URI_FUNCTION.toPb()));
    }

    private void compareUserDefinedFunction(UserDefinedFunction expected, UserDefinedFunction value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.content(), (Object)value.content());
    }
}

