/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ViewDefinitionTest {
    private static final String VIEW_QUERY = "VIEW QUERY";
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final ViewDefinition VIEW_DEFINITION = ViewDefinition.builder((String)"VIEW QUERY", USER_DEFINED_FUNCTIONS).build();

    @Test
    public void testToBuilder() {
        this.compareViewDefinition(VIEW_DEFINITION, VIEW_DEFINITION.toBuilder().build());
        ViewDefinition viewDefinition = VIEW_DEFINITION.toBuilder().query("NEW QUERY").build();
        Assert.assertEquals((Object)"NEW QUERY", (Object)viewDefinition.query());
        viewDefinition = viewDefinition.toBuilder().query(VIEW_QUERY).build();
        this.compareViewDefinition(VIEW_DEFINITION, viewDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        ViewDefinition viewDefinition = ViewDefinition.of((String)VIEW_QUERY);
        Assert.assertEquals((Object)viewDefinition, (Object)viewDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)VIEW_QUERY, (Object)VIEW_DEFINITION.query());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)VIEW_DEFINITION.type());
        Assert.assertEquals(USER_DEFINED_FUNCTIONS, (Object)VIEW_DEFINITION.userDefinedFunctions());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)VIEW_DEFINITION.toPb()) instanceof ViewDefinition));
        this.compareViewDefinition(VIEW_DEFINITION, (ViewDefinition)TableDefinition.fromPb((Table)VIEW_DEFINITION.toPb()));
    }

    private void compareViewDefinition(ViewDefinition expected, ViewDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.query(), (Object)value.query());
        Assert.assertEquals((Object)expected.userDefinedFunctions(), (Object)value.userDefinedFunctions());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

